/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gwttools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class GwtBuildHelper
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GwtBuildHelper.class);
    private final String warPath;

    public static void copyCompiledGwtModule(String warPath, String srcMainWebapp, String moduleName) {
        File targetGwt = new File(warPath + "/" + moduleName);
        if (!targetGwt.exists()) {
            log.error("GWT data not found in " + targetGwt.getAbsolutePath() + ". Some AJAX will not work. \n Please run 'mvn gwt:compile' first" + "Or make sure your module has the correct rename-to entry.");
            System.exit(1);
        }
        assert (targetGwt.isDirectory());
        File sourceWebAppGwt = new File(srcMainWebapp + "/" + moduleName);
        assert (sourceWebAppGwt.getParentFile().exists()) : "Found no folder " + sourceWebAppGwt.getParentFile().getAbsolutePath();
        log.info("Copying GWT files temporarily to " + sourceWebAppGwt.getAbsolutePath());
        FileUtils.deleteQuietly((File)sourceWebAppGwt);
        sourceWebAppGwt.mkdirs();
        try {
            FileUtils.copyDirectory((File)targetGwt, (File)sourceWebAppGwt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean looksLikeGwtDir(File dir) {
        File clearCache = new File(dir, "clear.cache.gif");
        File hosted = new File(dir, "hosted.html");
        File devmode = new File(dir, "gwt.devmode.js");
        return clearCache.exists() && (hosted.exists() || devmode.exists());
    }

    public static void copyFile(String srcFile, String targetFile) {
        File src = new File(srcFile);
        File target = new File(targetFile);
        try {
            FileUtils.copyFile((File)src, (File)target);
        }
        catch (IOException e) {
            log.error("Could not copy from '" + srcFile + "' to '" + targetFile + "'", (Throwable)e);
        }
    }

    public static List<File> autoDiscoverAllGwtModulesInTarget(File targetDir) {
        File[] subDirs;
        ArrayList<File> list = new ArrayList<File>();
        assert (targetDir.isDirectory());
        for (File f : subDirs = targetDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            if (f.getName().contains(".gen.")) {
                log.info("Found GWT module " + f.getAbsolutePath() + "\n" + "  but ignoring it, because it looks like an auto-generated domain model, from Xydra OO");
            }
            list.add(f);
        }
        return list;
    }

    public static void copyAllGwtModulesFoundInTarget(String warPath, String srcMainWebapp) {
        List<File> subDirs;
        File targetDir = new File(warPath);
        if (!targetDir.exists()) {
            log.error("Target WAR dir not found as \n  " + targetDir.getAbsolutePath() + "\n" + "Compile something first, e.g. call 'mvn compile'\n" + " - and make sure your pom is packaging=war.");
            System.exit(1);
        }
        if ((subDirs = GwtBuildHelper.autoDiscoverAllGwtModulesInTarget(targetDir)).isEmpty()) {
            log.warn("No subdirectories found in " + targetDir.getAbsolutePath() + " - nothing copied.");
            return;
        }
        assert (subDirs != null);
        HashSet<String> foundModules = new HashSet<String>();
        for (File subDir : subDirs) {
            if (!GwtBuildHelper.looksLikeGwtDir(subDir)) continue;
            String moduleName = subDir.getName();
            foundModules.add(moduleName);
            GwtBuildHelper.copyCompiledGwtModule(warPath, srcMainWebapp, moduleName);
        }
        if (foundModules.isEmpty()) {
            log.warn("Auto-discovered ZERO GWT modules");
        } else {
            log.info("Auto-discovered and copied these GWT modules: " + foundModules);
        }
    }

    public GwtBuildHelper(String warPath) {
        this.warPath = warPath;
    }

    @Override
    public void run() {
        GwtBuildHelper.copyAllGwtModulesFoundInTarget(this.warPath, "./src/main/webapp");
    }
}

