/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tupleinf;

import com.google.gwt.thirdparty.guava.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xydra.index.IEntrySet;
import org.xydra.index.query.Constraint;

public class CombinedEntrySet<E>
implements IEntrySet<E> {
    private static final long serialVersionUID = 1L;
    private final IEntrySet<E> a;
    private final IEntrySet<E> b;

    public static <E> IEntrySet<E> combine(IEntrySet<E> a, IEntrySet<E> b) {
        if (a == b) {
            return a;
        }
        return new CombinedEntrySet<E>(a, b);
    }

    public void clear() {
        this.b.clear();
    }

    public boolean isEmpty() {
        return this.a.isEmpty() && this.b.isEmpty();
    }

    public Iterator<E> iterator() {
        return Iterators.concat((Iterator)this.a.iterator(), (Iterator)this.b.iterator());
    }

    public boolean deIndex(E entry) {
        if (this.a.contains(entry)) {
            return false;
        }
        return this.b.deIndex(entry);
    }

    public boolean index(E entry) {
        if (this.a.contains(entry)) {
            return false;
        }
        return this.a.index(entry);
    }

    public IEntrySet.IEntrySetDiff<E> computeDiff(IEntrySet<E> other) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(E entry) {
        return this.a.contains(entry) || this.b.contains(entry);
    }

    public Iterator<E> constraintIterator(Constraint<E> entryConstraint) {
        return Iterators.concat((Iterator)this.a.constraintIterator(entryConstraint), (Iterator)this.b.constraintIterator(entryConstraint));
    }

    public int size() {
        return this.a.size() + this.b.size();
    }

    public Set<E> toSet() {
        HashSet set = new HashSet();
        set.addAll(this.a.toSet());
        set.addAll(this.b.toSet());
        return set;
    }

    public CombinedEntrySet(IEntrySet<E> a, IEntrySet<E> b) {
        this.a = a;
        this.b = b;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        Iterator<E> it = this.toSet().iterator();
        while (it.hasNext()) {
            E e = it.next();
            b.append(e.toString());
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        b.append("}");
        return b.toString();
    }
}

