/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.InstrumentSpec;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.Trial;
import com.google.caliper.model.VmSpec;
import com.google.caliper.util.Stdout;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.rank.Percentile;

final class ConsoleResultProcessor
implements ResultProcessor {
    private final PrintWriter stdout;
    private Set<InstrumentSpec> instrumentSpecs = Sets.newHashSet();
    private Set<VmSpec> vmSpecs = Sets.newHashSet();
    private Set<BenchmarkSpec> benchmarkSpecs = Sets.newHashSet();
    private int numMeasurements = 0;

    @Inject
    ConsoleResultProcessor(@Stdout PrintWriter stdout) {
        this.stdout = stdout;
    }

    @Override
    public void processTrial(Trial trial) {
        ImmutableListMultimap measurementsIndex = new ImmutableListMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).putAll((Multimap)Multimaps.index(trial.measurements(), (Function)new Function<Measurement, String>(){

            public String apply(Measurement input) {
                return input.description();
            }
        })).build();
        for (Map.Entry entry : measurementsIndex.asMap().entrySet()) {
            Collection measurements = (Collection)entry.getValue();
            ImmutableSet units = FluentIterable.from((Iterable)measurements).transform((Function)new Function<Measurement, String>(){

                public String apply(Measurement input) {
                    return input.value().unit();
                }
            }).toSet();
            double[] weightedValues = new double[measurements.size()];
            int i = 0;
            for (Measurement measurement : measurements) {
                weightedValues[i] = measurement.value().magnitude() / measurement.weight();
                ++i;
            }
            Percentile percentile = new Percentile();
            percentile.setData(weightedValues);
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(weightedValues);
            String unit = (String)Iterables.getOnlyElement((Iterable)units);
            this.stdout.printf("  %s%s: min=%.2f, 1st qu.=%.2f, median=%.2f, mean=%.2f, 3rd qu.=%.2f, max=%.2f%n", entry.getKey(), unit.isEmpty() ? "" : "(" + unit + ")", descriptiveStatistics.getMin(), percentile.evaluate(25.0), percentile.evaluate(50.0), descriptiveStatistics.getMean(), percentile.evaluate(75.0), descriptiveStatistics.getMax());
        }
        this.instrumentSpecs.add(trial.instrumentSpec());
        Scenario scenario = trial.scenario();
        this.vmSpecs.add(scenario.vmSpec());
        this.benchmarkSpecs.add(scenario.benchmarkSpec());
        this.numMeasurements += trial.measurements().size();
    }

    @Override
    public void close() {
        this.stdout.printf("Collected %d measurements from:%n", this.numMeasurements);
        this.stdout.printf("  %d instrument(s)%n", this.instrumentSpecs.size());
        this.stdout.printf("  %d virtual machine(s)%n", this.vmSpecs.size());
        this.stdout.printf("  %d benchmark(s)%n", this.benchmarkSpecs.size());
        this.stdout.flush();
    }
}

