/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.Parameter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public final class ParameterSet {
    final ImmutableMap<String, Parameter> map;

    public static ParameterSet create(Class<?> theClass, Class<? extends Annotation> annotationClass) throws InvalidBenchmarkException {
        ImmutableSortedMap.Builder parametersBuilder = ImmutableSortedMap.naturalOrder();
        for (Field field : theClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            Parameter parameter = Parameter.create(field);
            parametersBuilder.put((Object)field.getName(), (Object)parameter);
        }
        return new ParameterSet((ImmutableMap<String, Parameter>)parametersBuilder.build());
    }

    private ParameterSet(ImmutableMap<String, Parameter> map) {
        this.map = map;
    }

    public Set<String> names() {
        return this.map.keySet();
    }

    public Parameter get(String name) {
        return (Parameter)this.map.get((Object)name);
    }

    public ImmutableSetMultimap<String, String> fillInDefaultsFor(ImmutableSetMultimap<String, String> explicitValues) throws InvalidBenchmarkException {
        ImmutableSetMultimap.Builder combined = ImmutableSetMultimap.builder();
        for (String name : Sets.union((Set)this.map.keySet(), (Set)explicitValues.keySet())) {
            Parameter parameter = (Parameter)this.map.get((Object)name);
            ImmutableSet values = explicitValues.containsKey((Object)name) ? explicitValues.get((Object)name) : parameter.defaults();
            combined.putAll((Object)name, (Iterable)values);
            if (!values.isEmpty()) continue;
            throw new InvalidBenchmarkException("ERROR: No default value provided for " + name, new Object[0]);
        }
        return combined.orderKeysBy((Comparator)Ordering.natural()).build();
    }

    public void injectAll(Object benchmark, Map<String, String> actualValues) {
        for (Parameter parameter : this.map.values()) {
            String value = actualValues.get(parameter.name());
            parameter.inject(benchmark, value);
        }
    }
}

