/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.csv.stream;

import org.xydra.base.value.ValueType;
import org.xydra.base.value.XValueStreamHandler;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class AbstractValueStream
implements XValueStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractValueStream.class);
    protected StringBuffer buf = new StringBuffer();

    public String getString() {
        return this.buf.toString();
    }

    public void startValue() {
    }

    public void endValue() {
    }

    public void startCollection(ValueType type) {
        this.buf.append("[");
    }

    public void endCollection() {
        this.buf.append("]");
    }

    public void javaBoolean(Boolean a) {
        this.buf.append(a);
    }

    public void javaDouble(Double a) {
        if (a == null) {
            this.javaNull();
        } else if (a.isInfinite() || a.isNaN()) {
            log.warn("Encoding an infinite/NaN-Double as null");
            this.javaNull();
        } else {
            String s = a.toString();
            if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
                while (s.endsWith("0")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.endsWith(".")) {
                    s = s.substring(0, s.length() - 1);
                }
            }
            this.buf.append(s);
        }
    }

    public void javaInteger(Integer a) {
        this.buf.append(a.toString());
    }

    public void javaLong(Long a) {
        this.buf.append(a.toString());
    }

    public void javaString(String a) {
        this.buf.append(this.encode(a.toString()));
    }

    public abstract String encode(String var1);

    public void javaNull() {
        this.buf.append("null");
    }
}

