/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.csv.stream;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xydra.base.Base;
import org.xydra.base.BaseRuntime;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.value.ValueType;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XCollectionValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.core.serialize.SerializedValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CsvValueReader {
    private static final Logger log = LoggerFactory.getLogger(CsvValueReader.class);
    private static final char APOS = '\'';
    private static final char COMMA = ',';

    public static XValue parseValue(String valueString, ValueType type) {
        if (type.isCollection()) {
            assert (valueString.startsWith("[")) : valueString;
            assert (valueString.endsWith("]"));
            return CsvValueReader.parseCollectionValue(valueString.substring(1, valueString.length() - 1), type);
        }
        return CsvValueReader.parsePlainValue(valueString, type);
    }

    public static XValue parsePlainValue(String valueString, ValueType type) {
        if (valueString.equals("null")) {
            return null;
        }
        switch (type) {
            case Address: {
                return BaseRuntime.getIDProvider().fromAddress(valueString.trim());
            }
            case Boolean: {
                return XV.toValue((boolean)Boolean.parseBoolean(valueString.trim()));
            }
            case Binary: {
                byte[] bytes = SerializedValue.deserializeBinaryContent((String)valueString.trim());
                return XV.toValue((byte[])bytes);
            }
            case Double: {
                return BaseRuntime.getValueFactory().createDoubleValue(Double.parseDouble(valueString.trim()));
            }
            case Integer: {
                return BaseRuntime.getValueFactory().createIntegerValue(Integer.parseInt(valueString.trim()));
            }
            case Long: {
                return BaseRuntime.getValueFactory().createLongValue(Long.parseLong(valueString.trim()));
            }
            case String: {
                return BaseRuntime.getValueFactory().createStringValue(valueString.trim());
            }
            case Id: {
                return Base.toId((String)valueString.trim());
            }
        }
        throw new AssertionError((Object)("Not a plain type? " + type));
    }

    public static XValue parseCollectionValue(String valueSequenceString, ValueType type) {
        assert (type.isCollection());
        if (type == ValueType.StringList || type == ValueType.StringSet) {
            List<String> list = CsvValueReader.toStringList(valueSequenceString);
            if (type == ValueType.StringList) {
                return XV.toStringListValue(list);
            }
            return XV.toStringSetValue(list);
        }
        String[] parts = valueSequenceString.split(",");
        switch (type) {
            case AddressList: 
            case AddressSet: 
            case AddressSortedSet: {
                ArrayList<XAddress> list = new ArrayList<XAddress>();
                for (String s : parts) {
                    list.add((XAddress)CsvValueReader.parsePlainValue(s.trim(), ValueType.Address));
                }
                switch (type) {
                    case AddressList: {
                        return XV.toAddressListValue(list);
                    }
                    case AddressSet: {
                        return XV.toAddressSetValue(list);
                    }
                    case AddressSortedSet: {
                        return XV.toAddressSortedSetValue(list);
                    }
                }
                throw new AssertionError();
            }
            case IdList: 
            case IdSet: 
            case IdSortedSet: {
                ArrayList<XId> list = new ArrayList<XId>();
                for (String s : parts) {
                    list.add((XId)CsvValueReader.parsePlainValue(s.trim(), ValueType.Id));
                }
                switch (type) {
                    case IdList: {
                        return XV.toIdListValue(list);
                    }
                    case IdSet: {
                        return XV.toIdSetValue(list);
                    }
                    case IdSortedSet: {
                        return XV.toIdSortedSetValue(list);
                    }
                }
                throw new AssertionError();
            }
            case BooleanList: {
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                for (String s : parts) {
                    list.add(Boolean.parseBoolean(s.trim()));
                }
                return XV.toBooleanListValue(list);
            }
            case DoubleList: {
                ArrayList<Double> list = new ArrayList<Double>();
                for (String s : parts) {
                    list.add(Double.parseDouble(s.trim()));
                }
                return XV.toDoubleListValue(list);
            }
            case LongList: {
                ArrayList<Long> list = new ArrayList<Long>();
                for (String s : parts) {
                    list.add(Long.parseLong(s.trim()));
                }
                return XV.toLongListValue(list);
            }
            case IntegerList: {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (String s : parts) {
                    list.add(Integer.parseInt(s.trim()));
                }
                return XV.toIntegerListValue(list);
            }
        }
        throw new AssertionError((Object)("Could not handle " + type));
    }

    public static String toCollectionString(XCollectionValue<?> value) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        boolean first = true;
        switch (value.getType()) {
            case AddressList: 
            case AddressSet: 
            case AddressSortedSet: {
                for (Object o : value) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append(o == null ? "null" : ((XAddress)o).toString());
                    first = false;
                }
                break;
            }
            case BooleanList: 
            case DoubleList: 
            case LongList: 
            case IntegerList: {
                for (Object o : value) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append(o == null ? "null" : o.toString());
                    first = false;
                }
                break;
            }
            case StringList: 
            case StringSet: {
                for (Object o : value) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append(o == null ? "null" : CsvValueReader.aposEncode((String)o));
                    first = false;
                }
                break;
            }
            case IdList: 
            case IdSet: 
            case IdSortedSet: {
                for (Object o : value) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append(o == null ? "null" : o.toString());
                    first = false;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + value.getType() + " is not a known collection type");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private static String aposEncode(String s) {
        return "'" + s.replace("'", "''") + "'";
    }

    private static boolean isNextChar(String s, int pos, char c) {
        return pos + 1 < s.length() && s.charAt(pos + 1) == c;
    }

    public static List<String> toStringList(String in) {
        int pos;
        LinkedList<String> result = new LinkedList<String>();
        if (in == null) {
            return result;
        }
        boolean inString = false;
        StringBuffer token = new StringBuffer();
        for (pos = 0; pos < in.length(); ++pos) {
            char c = in.charAt(pos);
            log.trace("Parsing __" + c + "__ inString?" + inString + " token=" + token);
            if (c == '\'') {
                if (CsvValueReader.isNextChar(in, pos, '\'')) {
                    if (CsvValueReader.isNextChar(in, pos + 1, ',') && !inString) {
                        log.trace("EmptyString");
                        pos += 2;
                        result.add("");
                        token = new StringBuffer();
                        continue;
                    }
                    log.trace("APOS");
                    token.append('\'');
                    ++pos;
                    continue;
                }
                if (inString) {
                    log.trace("TokenEnd");
                    inString = false;
                    result.add(token.toString());
                    token.setLength(0);
                    continue;
                }
                log.trace("TokenStart");
                inString = true;
                token = new StringBuffer();
                continue;
            }
            if (inString) {
                log.trace("InToken");
                token.append(c);
                continue;
            }
            log.trace("OutToken");
            assert (c == ',' || c == ' ') : "c is " + c + " in " + in;
        }
        assert (in.equals("") || in.charAt(pos - 1) == '\'');
        return result;
    }

    public static void main(String[] args) {
        List<String> list = CsvValueReader.toStringList("'fo''o','ba,r''','','stu,ff','es''cap''ed','maybeeven'',''withcomma'");
        Object[] result = list.toArray(new String[list.size()]);
        Object[] expected = new String[]{"fo'o", "ba,r'", "", "stu,ff", "es'cap'ed", "maybeeven','withcomma'"};
        log.trace(Arrays.toString(result));
        log.trace(Arrays.toString(expected));
        assert (expected.length == result.length);
    }

    public static String toString(XValue value) {
        if (value.getType().isCollection()) {
            return CsvValueReader.toCollectionString((XCollectionValue)value);
        }
        return CsvValueReader.toPlainString(value);
    }

    public static String toPlainString(XValue value) {
        switch (value.getType()) {
            case Address: 
            case Boolean: 
            case Double: 
            case Integer: 
            case Long: 
            case Id: {
                return value.toString();
            }
            case Binary: {
                byte[] bytes = ((XBinaryValue)value).getValue();
                try {
                    String s = new String(bytes, "utf-8");
                    return s;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("No utf-8 on this platform?");
                }
            }
            case String: {
                return CsvValueReader.aposEncode(value.toString());
            }
        }
        throw new IllegalArgumentException("No known plain type " + value.getType());
    }
}

