/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathTemplate {
    static final String ANY_REGEX = ".*";
    static final String PATH_REGEX = "/";
    static final String VAR_REGEX = "([^/]+)";
    static final String END_REGEX = "/?";
    private transient Pattern p;
    private final String regex;
    private final List<String> variableNames = new ArrayList<String>();

    public PathTemplate(String pathExpression) {
        if (!pathExpression.startsWith(PATH_REGEX)) {
            throw new IllegalArgumentException("Path must start with '/'. Path ='" + pathExpression + "'");
        }
        if (pathExpression.contains("//")) {
            throw new IllegalArgumentException("Path may not contain '//'. Path ='" + pathExpression + "'");
        }
        String[] segments = pathExpression.substring(1).split(PATH_REGEX);
        StringBuffer regexBuf = new StringBuffer();
        for (String segment : segments) {
            regexBuf.append(PATH_REGEX);
            if (segment.startsWith("{")) {
                if (!segment.endsWith("}")) {
                    throw new IllegalArgumentException("Segment in path must look like '{name}'. Closing brace missing in '" + segment + "'.");
                }
                String variableName = segment.substring(1, segment.length() - 1);
                this.variableNames.add(variableName);
                regexBuf.append(VAR_REGEX);
                continue;
            }
            regexBuf.append(segment);
        }
        regexBuf.append(END_REGEX);
        this.regex = regexBuf.toString();
        this.p = Pattern.compile(this.regex);
    }

    public List<String> extractVariables(String path) {
        Matcher m = this.p.matcher(path);
        if (m.groupCount() != this.variableNames.size()) {
            throw new IllegalArgumentException("Path contains a different number of variables (" + m.groupCount() + ") than the template (" + this.variableNames.size() + ")");
        }
        if (!m.matches()) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            String value = m.group(i);
            values.add(value);
        }
        return values;
    }

    public String getRegex() {
        return this.regex;
    }

    protected List<String> getVariableNames() {
        return this.variableNames;
    }

    public boolean matches(String path) {
        return this.p.matcher(path).matches();
    }

    public String toString() {
        return "'" + this.regex + "', variables: " + this.variableNames;
    }
}

