/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.xydra.common.NanoClock;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.ExceptionHandlerException;
import org.xydra.restless.Flag;
import org.xydra.restless.IMultipartFormDataHandler;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.PathTemplate;
import org.xydra.restless.ProgressManager;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessContextImpl;
import org.xydra.restless.RestlessException;
import org.xydra.restless.RestlessExceptionHandler;
import org.xydra.restless.RestlessMethodExecutionParameters;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.RestlessStatic;
import org.xydra.restless.RestlessUtils;
import org.xydra.restless.XydraCoreCopy;
import org.xydra.restless.utils.QueryStringUtils;
import org.xydra.restless.utils.ServletUtils;

class RestlessMethod {
    private static final String UPLOAD_PARAM = "_upload_";
    private static ConcurrentHashMap<Class<?>, Object> instanceCache = new ConcurrentHashMap(20, 0.75f, 5);
    private static Logger log = LoggerFactory.getThreadSafeLogger(RestlessMethod.class);
    private final boolean adminOnly;
    private final String httpMethod;
    private final Object instanceOrClass;
    private final String methodName;
    private final RestlessParameter[] requiredNamedParameters;
    private final PathTemplate pathTemplate;

    protected RestlessMethod(Object object, String httpMethod, String methodName, PathTemplate pathTemplate, boolean adminOnly, RestlessParameter[] parameter) {
        this.instanceOrClass = object;
        this.httpMethod = httpMethod;
        this.methodName = methodName;
        this.pathTemplate = pathTemplate;
        this.adminOnly = adminOnly;
        this.requiredNamedParameters = parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestlessMethodExecutionParameters prepareMethodExecution(Restless restless, HttpServletRequest req, HttpServletResponse res, NanoClock requestClock) throws IOException {
        Method method;
        requestClock.stopAndStart("servlet->restless.run");
        res.setHeader("X-Frame-Options", Restless.X_FRAME_OPTIONS_DEFAULT);
        Object object = this.instanceOrClass;
        synchronized (object) {
            method = RestlessStatic.methodByName(this.instanceOrClass, this.methodName);
        }
        if (method == null) {
            res.sendError(500, "Malconfigured server. Method '" + this.methodName + "' not found in '" + RestlessStatic.instanceOrClass_className(this.instanceOrClass) + "'");
            return null;
        }
        ArrayList<Object> javaMethodArgs = new ArrayList<Object>();
        Map<String, String> urlPathParameterMap = RestlessUtils.getUrlParametersAsMap(req, this.pathTemplate);
        Map<String, String> cookieMap = ServletUtils.getCookiesAsMap(req);
        String uniqueRequestId = RestlessMethod.reuseOrCreateUniqueRequestIdentifier(urlPathParameterMap, cookieMap);
        RestlessContextImpl restlessContext = new RestlessContextImpl(restless, req, res, uniqueRequestId);
        Flag hasHttpServletResponseParameter = new Flag(false);
        boolean isMultiPartStreamHandlerMethod = RestlessMethod.isMultiPartFormEncoded_HandlerMethod(method);
        boolean mayReadRequestBody = req.getMethod().equals("GET") || !isMultiPartStreamHandlerMethod;
        Map<String, Object> multipartMap = null;
        Map<String, List<String>> queryMap = null;
        if (mayReadRequestBody) {
            multipartMap = RestlessMethod.getMultiPartPostAsMap(req);
        } else {
            queryMap = QueryStringUtils.parse(req.getQueryString());
        }
        assert (!mayReadRequestBody || multipartMap != null);
        assert (mayReadRequestBody || queryMap != null);
        int boundNamedParameterNumber = 0;
        for (Class<?> requiredParamType : method.getParameterTypes()) {
            boolean filled = RestlessMethod.fillBuiltInInjectedParameter(requiredParamType, javaMethodArgs, hasHttpServletResponseParameter, restlessContext, requestClock);
            if (filled) continue;
            if (this.requiredNamedParameters.length == 0) {
                throw new IllegalArgumentException("It looks like you have parameters in your java method '" + RestlessMethod.methodReference(this.instanceOrClass, method) + "' for which there have no RestlessParameter been defined.");
            }
            if (this.requiredNamedParameters.length <= boundNamedParameterNumber) {
                throw new IllegalArgumentException("Require " + this.requiredNamedParameters.length + " named parameters in method '" + RestlessStatic.toClass(this.instanceOrClass).getCanonicalName() + ":" + method.getName() + "', processed " + boundNamedParameterNumber + " parameters from request so far. Required parameters: " + Arrays.toString(this.requiredNamedParameters) + ". I.e. your Java method wants more parameters than defined in your restless() method.");
            }
            RestlessParameter requiredParam = this.requiredNamedParameters[boundNamedParameterNumber];
            Object value = RestlessMethod.getNamedParameter(requiredParam.isArray(), requiredParam.getName(), requiredParam.getDefaultValue(), requiredParam.isRequired(), mayReadRequestBody, req, urlPathParameterMap, cookieMap, queryMap, multipartMap);
            javaMethodArgs.add(value);
            if (++boundNamedParameterNumber <= this.requiredNamedParameters.length) continue;
            log.debug("More non-trivial parameter required by Java method than mapped via RestlessParameters");
            return null;
        }
        String progressToken = (String)RestlessMethod.getNamedParameter(false, "_progressToken_", null, false, mayReadRequestBody, req, urlPathParameterMap, cookieMap, queryMap, multipartMap);
        return new RestlessMethodExecutionParameters(method, isMultiPartStreamHandlerMethod, progressToken, restlessContext, javaMethodArgs, hasHttpServletResponseParameter.getValue(), uniqueRequestId, requestClock);
    }

    private static Object getNamedParameter(boolean parameterIsArray, String parameterName, Object defaultValue, boolean isRequired, boolean mayReadRequestBody, HttpServletRequest req, Map<String, String> urlPathParameterMap, Map<String, String> cookieMap, Map<String, List<String>> queryMap, Map<String, Object> multipartMap) {
        Object value = null;
        if (!parameterIsArray) {
            value = urlPathParameterMap.get(parameterName);
        }
        if (RestlessMethod.notSet(value)) {
            if (mayReadRequestBody) {
                String[] values = req.getParameterValues(parameterName);
                if (values != null) {
                    if (parameterIsArray) {
                        value = values;
                    } else if (values.length > 1) {
                        HashSet<String> uniqueValues = new HashSet<String>();
                        for (String s : values) {
                            uniqueValues.add(s);
                        }
                        if (uniqueValues.size() > 1) {
                            StringBuffer buf = new StringBuffer();
                            for (int j = 0; j < values.length; ++j) {
                                buf.append(values[j]);
                                buf.append(", ");
                            }
                            if (isRequired) {
                                throw new IllegalArgumentException("Parameter '" + parameterName + "' required but not explicitly defined. Found multiple values.");
                            }
                            log.warn("Multiple values for parameter '" + parameterName + "' (values=" + buf.toString() + ") from queryString and POST params, using default (" + defaultValue + ")");
                            value = defaultValue;
                        } else {
                            value = uniqueValues.iterator().next();
                        }
                    } else {
                        value = values[0];
                    }
                }
            } else {
                assert (queryMap != null);
                List<String> values = queryMap.get(parameterName);
                if (values != null) {
                    if (parameterIsArray) {
                        value = values.toArray();
                    } else if (values.size() > 1) {
                        HashSet<String> uniqueValues = new HashSet<String>();
                        for (String s : values) {
                            uniqueValues.add(s);
                        }
                        if (uniqueValues.size() > 1) {
                            StringBuffer buf = new StringBuffer();
                            for (int j = 0; j < values.size(); ++j) {
                                buf.append(values.get(j));
                                buf.append(", ");
                            }
                            if (isRequired) {
                                throw new IllegalArgumentException("Parameter '" + parameterName + "' required but not explicitly defined. Found multiple values.");
                            }
                            log.warn("Multiple values for parameter '" + parameterName + "' (values=" + buf.toString() + ") from queryString and POST params, using default (" + defaultValue + ")");
                            value = defaultValue;
                        } else {
                            value = uniqueValues.iterator().next();
                        }
                    } else {
                        value = values.get(0);
                    }
                }
            }
        }
        if (RestlessMethod.notSet(value) && !parameterIsArray) {
            value = cookieMap.get(parameterName);
        }
        if (mayReadRequestBody && RestlessMethod.notSet(value) && !parameterIsArray) {
            assert (multipartMap != null);
            value = multipartMap.get(parameterName);
        }
        if (RestlessMethod.notSet(value)) {
            if (isRequired) {
                log.debug("Parameter '" + parameterName + "' required but no explicitly defined. Found no value.");
                return null;
            }
            value = defaultValue;
        }
        return value;
    }

    private static boolean fillBuiltInInjectedParameter(Class<?> requiredParamType, List<Object> javaMethodArgs, Flag hasHttpServletResponseParameter, IRestlessContext restlessContext, NanoClock requestClock) {
        if (requiredParamType.equals(HttpServletResponse.class)) {
            javaMethodArgs.add(restlessContext.getResponse());
            hasHttpServletResponseParameter.setTrue();
            return true;
        }
        if (requiredParamType.equals(HttpServletRequest.class)) {
            javaMethodArgs.add(restlessContext.getRequest());
            return true;
        }
        if (requiredParamType.equals(Restless.class)) {
            javaMethodArgs.add((Object)restlessContext.getRestless());
            return true;
        }
        if (requiredParamType.equals(IRestlessContext.class)) {
            javaMethodArgs.add(restlessContext);
            hasHttpServletResponseParameter.setTrue();
            return true;
        }
        if (requiredParamType.equals(NanoClock.class)) {
            javaMethodArgs.add(requestClock);
            return true;
        }
        return false;
    }

    private static boolean isMultiPartFormEncoded_HandlerMethod(Method method) {
        return method.getReturnType().equals(IMultipartFormDataHandler.class);
    }

    public boolean execute(RestlessMethodExecutionParameters params, Restless restless, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Method method = params.getMethod();
        Thread.currentThread().setName("Restless-exe-" + method.getName());
        IRestlessContext restlessContext = params.getRestlessContext();
        List<Object> javaMethodArgs = params.getJavaMethodArgs();
        boolean hasHttpServletResponseParameter = params.hasHttpServletResponseParameter();
        String uniqueRequestId = params.getUniqueRequestId();
        NanoClock requestClock = params.getClock();
        try {
            requestClock.stopAndStart("restless.execute->invoke");
            restless.fireRequestStarted(restlessContext);
            Object result = RestlessMethod.invokeMethod(method, this.instanceOrClass, javaMethodArgs);
            requestClock.stopAndStart("invoke " + RestlessMethod.methodReference(this.instanceOrClass, method));
            if (params.isMultipartFormDataHandler()) {
                String progressToken = params.getProgressToken();
                IMultipartFormDataHandler multipartFormDataHandler = (IMultipartFormDataHandler)result;
                RestlessMethod.handleStreaming(restlessContext, multipartFormDataHandler, progressToken);
                requestClock.stopAndStart("stream " + RestlessMethod.methodReference(this.instanceOrClass, method));
            } else if (!hasHttpServletResponseParameter) {
                res.setContentType("text/plain; charset=utf-8");
                res.setStatus(200);
                PrintWriter w = res.getWriter();
                ((Writer)w).write("Executed " + RestlessMethod.methodReference(this.instanceOrClass, method) + "\n");
                if (result != null && result instanceof String) {
                    ((Writer)w).write("Result: " + result);
                }
                ((Writer)w).flush();
            }
            restless.fireRequestFinished(restlessContext);
            requestClock.stopAndStart("response");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RestlessException) {
                RestlessException re = (RestlessException)cause;
                res.setStatus(re.getStatusCode());
                res.setContentType("text/plain; charset=utf-8");
                PrintWriter w = res.getWriter();
                ((Writer)w).write(re.getMessage());
            }
            RestlessContextImpl context = new RestlessContextImpl(restless, req, res, uniqueRequestId);
            boolean handled = false;
            try {
                handled = RestlessMethod.callLocalExceptionHandler(cause, this.instanceOrClass, context);
            }
            catch (InvocationTargetException ite) {
                cause = new ExceptionHandlerException(e.getCause());
            }
            catch (Throwable th) {
                cause = new ExceptionHandlerException(th);
            }
            if (!handled) {
                try {
                    handled = RestlessMethod.callGlobalExceptionHandlers(cause, context);
                }
                catch (Throwable th) {
                    cause = new ExceptionHandlerException(th);
                }
            }
            if (!handled) {
                String stacktraceHtml = XydraCoreCopy.firstNLines(e, 500);
                if (!res.isCommitted()) {
                    res.sendError(500, e + " -- " + stacktraceHtml);
                }
                assert (log != null);
                log.error("Exception while executing RESTless method.", (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            res.sendError(500, e.toString());
            log.error("RESTless method registered with wrong arguments: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            res.sendError(500, e.toString());
            log.error("", (Throwable)e);
        }
        Thread.currentThread().setName("Restless-done-" + method.getName());
        return true;
    }

    private static void handleStreaming(IRestlessContext ctx, IMultipartFormDataHandler multipartFormDataHandler, final String progressToken) throws IOException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)ctx.getRequest());
        assert (isMultipart);
        IMultipartFormDataHandler.IProgressReporter progressReporter = null;
        if (progressToken != null) {
            progressReporter = new IMultipartFormDataHandler.IProgressReporter(){

                @Override
                public void reportProgress(String progressMessage) {
                    ProgressManager.DEFAULT_PROGRESS_BROKER.appendProgress(progressToken, progressMessage);
                }
            };
        }
        ServletFileUpload upload = new ServletFileUpload();
        try {
            FileItemIterator itemStreamIt = upload.getItemIterator(ctx.getRequest());
            while (itemStreamIt.hasNext()) {
                FileItemStream item = itemStreamIt.next();
                String fieldName = item.getFieldName();
                String contentType = item.getContentType();
                String contentName = item.getName();
                HashMap<String, String> requestHeaderMapOfOneItem = new HashMap<String, String>();
                FileItemHeaders headers = item.getHeaders();
                Iterator headerNameIt = headers.getHeaderNames();
                while (headerNameIt.hasNext()) {
                    String headerName = (String)headerNameIt.next();
                    String headerValue = headers.getHeader(headerName);
                    requestHeaderMapOfOneItem.put(headerName, headerValue);
                }
                InputStream is = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)is, (String)"UTF-8");
                    multipartFormDataHandler.onContentPartString(fieldName, contentName, requestHeaderMapOfOneItem, contentType, value, progressReporter);
                } else {
                    multipartFormDataHandler.onContentPartStream(fieldName, contentName, requestHeaderMapOfOneItem, contentType, is, progressReporter);
                }
                is.close();
            }
            multipartFormDataHandler.onEndOfRequest(ctx, progressReporter);
        }
        catch (FileUploadException e) {
            if (progressReporter != null) {
                progressReporter.reportProgress("ERROR");
            }
            throw new IOException("while uploading", e);
        }
    }

    private static Map<String, Object> getMultiPartPostAsMap(HttpServletRequest req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            return map;
        }
        ServletFileUpload upload = new ServletFileUpload();
        try {
            FileItemIterator it = upload.getItemIterator(req);
            while (it.hasNext()) {
                FileItemStream item = it.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)stream);
                    map.put(fieldName, value);
                    continue;
                }
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                if (fieldName.equals(UPLOAD_PARAM)) {
                    map.put(UPLOAD_PARAM, bytes);
                    continue;
                }
                map.put(fieldName, bytes);
                map.put(UPLOAD_PARAM, bytes);
            }
        }
        catch (FileUploadException e) {
            log.warn("", (Throwable)e);
            throw new RestlessException(500, "Could not process file upload", e);
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RestlessException(500, "Could not process file upload", e);
        }
        return map;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    protected PathTemplate getPathTemplate() {
        return this.pathTemplate;
    }

    protected Object getInstanceOrClass() {
        return this.instanceOrClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    protected RestlessParameter[] getRequiredNamedParameter() {
        return this.requiredNamedParameters;
    }

    private static boolean notSet(Object value) {
        return value == null || value.equals("");
    }

    private static String methodReference(Object instanceOrClass, Method method) {
        Class<?> clazz = instanceOrClass instanceof Class ? (Class<?>)instanceOrClass : instanceOrClass.getClass();
        return clazz.getSimpleName() + "." + method.getName() + "(..)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invokeMethod(Method method, Object instanceOrClass, List<Object> javaMethodArgs) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object result;
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (isStatic) {
            result = method.invoke(null, javaMethodArgs.toArray(new Object[0]));
        } else {
            Object instance;
            Object object = instance = RestlessMethod.toInstance(instanceOrClass);
            synchronized (object) {
                result = method.invoke(instance, javaMethodArgs.toArray(new Object[0]));
            }
        }
        return result;
    }

    private static boolean callLocalExceptionHandler(Throwable cause, Object instanceOrClass, IRestlessContext context) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method method = RestlessStatic.methodByName(instanceOrClass, "onException");
        if (method == null) {
            return false;
        }
        ArrayList<Object> javaMethodArgs = new ArrayList<Object>();
        for (Class<?> requiredParamType : method.getParameterTypes()) {
            if (requiredParamType.equals(Throwable.class)) {
                javaMethodArgs.add(cause);
                continue;
            }
            if (requiredParamType.equals(HttpServletResponse.class)) {
                javaMethodArgs.add(context.getResponse());
                continue;
            }
            if (requiredParamType.equals(HttpServletRequest.class)) {
                javaMethodArgs.add(context.getRequest());
                continue;
            }
            if (requiredParamType.equals(Restless.class)) {
                javaMethodArgs.add((Object)context.getRestless());
                continue;
            }
            if (!requiredParamType.equals(IRestlessContext.class)) continue;
            javaMethodArgs.add(context);
        }
        Object result = RestlessMethod.invokeMethod(method, instanceOrClass, javaMethodArgs);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean callGlobalExceptionHandlers(Throwable cause, IRestlessContext context) {
        List<RestlessExceptionHandler> exceptionHandlers;
        List<RestlessExceptionHandler> list = exceptionHandlers = context.getRestless().exceptionHandlers;
        synchronized (list) {
            for (RestlessExceptionHandler handler : exceptionHandlers) {
                if (!handler.handleException(cause, context)) continue;
                return true;
            }
            return false;
        }
    }

    private static Object toInstance(Object instanceOrClass) {
        if (instanceOrClass instanceof Class) {
            Class clazz = (Class)instanceOrClass;
            Object instance = instanceCache.get(clazz);
            if (instance != null) {
                return instance;
            }
            try {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                try {
                    instance = constructor.newInstance(new Object[0]);
                    Object previousInstance = instanceCache.putIfAbsent(clazz, instance);
                    if (previousInstance != null) {
                        return previousInstance;
                    }
                    return instance;
                }
                catch (IllegalArgumentException e) {
                    throw new RestlessException(500, "Server misconfigured - constructor needs to have no parameters", e);
                }
                catch (InstantiationException e) {
                    throw new RestlessException(500, "Server misconfigured", e);
                }
                catch (IllegalAccessException e) {
                    throw new RestlessException(500, "Server misconfigured", e);
                }
                catch (InvocationTargetException e) {
                    throw new RestlessException(500, "Server misconfigured", e);
                }
            }
            catch (SecurityException e) {
                throw new RestlessException(500, "Server misconfigured", e);
            }
            catch (NoSuchMethodException e) {
                throw new RestlessException(500, "Server misconfigured - constructor needs to have no parameters", e);
            }
        }
        return instanceOrClass;
    }

    public static String createUniqueRequestIdentifier() {
        return UUID.randomUUID().toString();
    }

    private static String reuseOrCreateUniqueRequestIdentifier(Map<String, String> urlParameter, Map<String, String> cookieMap) {
        String requestId = urlParameter.get("restless__rid");
        if (requestId == null) {
            requestId = cookieMap.get("restless__rid");
        }
        if (requestId == null) {
            requestId = RestlessMethod.createUniqueRequestIdentifier();
        }
        return requestId;
    }

    public String toString() {
        return this.pathTemplate + " ==> " + this.instanceOrClass.getClass() + "." + this.methodName + "(...)";
    }
}

