/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedHtmlUtils {
    private static final String MALICIOUS_INPUT_SAMPLE = "Dirk<script>alert('test');</script>";

    public static String link(String url, String text) {
        return "<a href=\"" + url + "\">" + text + "</a>";
    }

    public static String link(String url) {
        return "<a href=\"" + url + "\">" + url + "</a>";
    }

    public static SubmitInput inputSubmit(String label) {
        return new SubmitInput(label);
    }

    public static Form form(METHOD method, String action) {
        return new Form(method, action);
    }

    public static Table table() {
        return new Table();
    }

    private static String attribute(String name, String value) {
        assert (name != null);
        if (value != null) {
            return " " + name + "=\"" + value + "\"";
        }
        return "";
    }

    public static String toDefinitionList(Map<String, ? extends Object> mapEntries) {
        StringBuffer buf = new StringBuffer();
        buf.append("<dl>\n");
        for (Map.Entry<String, ? extends Object> e : mapEntries.entrySet()) {
            buf.append("<dt>" + e.getKey() + "</dt><dd>" + e.getValue() + "</dd>\n");
        }
        buf.append("</dl>\n");
        return buf.toString();
    }

    public static String toOrderedList(Collection<String> listEntries) {
        StringBuffer buf = new StringBuffer();
        buf.append("<ol>\n");
        for (String li : listEntries) {
            buf.append("<li>" + li + "</li>\n");
        }
        buf.append("</ol>\n");
        return buf.toString();
    }

    public static String toOrderedList(String ... listItemContent) {
        return SharedHtmlUtils.toOrderedList(Arrays.asList(listItemContent));
    }

    public static String sanitize(String s) {
        if (s == null) {
            return null;
        }
        return SharedHtmlUtils.htmlEncode(s);
    }

    public static Set<String> sanitize(Set<String> unsafe) {
        if (unsafe == null) {
            return null;
        }
        HashSet<String> safe = new HashSet<String>();
        for (String u : unsafe) {
            safe.add(SharedHtmlUtils.sanitize(u));
        }
        return safe;
    }

    public static void main(String[] args) {
        System.out.println(SharedHtmlUtils.sanitize(MALICIOUS_INPUT_SAMPLE));
    }

    public static final String htmlEncode(String raw) {
        String safe = raw;
        safe = safe.replace("&", "&amp;");
        safe = safe.replace("<", "&lt;");
        safe = safe.replace("\u00ab", "&lt");
        safe = safe.replace(">", "&gt;");
        safe = safe.replace("\u00bb", "&lt");
        safe = safe.replace("'", "&#39;");
        safe = safe.replace("\"", "&quot;");
        return safe;
    }

    public static class ScriptLink
    implements HeadChild {
        private final String href;

        public ScriptLink(String href) {
            this.href = href;
        }

        public String toString() {
            return "<script src=\"" + this.href + "\"></script>";
        }
    }

    public static interface HeadChild {
    }

    public static class HeadLinkStyle
    extends HeadLink {
        public HeadLinkStyle(String href) {
            super(href, "stylesheet", "text/css");
        }
    }

    public static class HeadLink
    implements HeadChild {
        private final String href;
        private final String rel;
        private final String type;

        public HeadLink(String href, String rel, String type) {
            this.href = href;
            this.rel = rel;
            this.type = type;
        }

        public String toString() {
            return "<link" + SharedHtmlUtils.attribute("href", this.href) + " " + SharedHtmlUtils.attribute("rel", this.rel) + " " + SharedHtmlUtils.attribute("type", this.type) + " />";
        }
    }

    public static class Form {
        private final String action;
        private final METHOD method;
        private final List<Input> inputs = new LinkedList<Input>();
        private boolean hasFileInput = false;

        public Form(METHOD method, String action) {
            this.method = method;
            this.action = action;
        }

        public Form withInputText(String name, String value) {
            this.inputs.add(new TextInput(name, value));
            return this;
        }

        public Form withHiddenInputText(String name, String value) {
            this.inputs.add(new HiddenInput(name, value));
            return this;
        }

        public Form withInputText(String name, String value, int size) {
            this.inputs.add(new TextInput(name, value, size));
            return this;
        }

        public Form withInputFile(String name) {
            this.inputs.add(new FileInput(name, 100));
            this.hasFileInput = true;
            return this;
        }

        public Form withInputTextArea(String name, String value, int cols, int rows) {
            this.inputs.add(new TextAreaInput(name, value, cols, rows));
            return this;
        }

        public Form withInputSubmit(String value) {
            this.inputs.add(new SubmitInput(value));
            return this;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("<form action='" + this.action + "' method='" + (Object)((Object)this.method) + "'" + (this.hasFileInput() ? " enctype='multipart/form-data'" : "") + ">");
            for (Input input : this.inputs) {
                buf.append(input.toString() + "\n");
            }
            buf.append("</form>");
            return buf.toString();
        }

        private boolean hasFileInput() {
            return this.hasFileInput;
        }
    }

    public static class Table {
        private final List<TableRow> rows = new LinkedList<TableRow>();

        public TableRow row() {
            TableRow row = new TableRow();
            this.rows.add(row);
            return row;
        }

        public String toString() {
            return this.toStringBuilder().toString();
        }

        public StringBuilder toStringBuilder() {
            StringBuilder b = new StringBuilder();
            b.append("<table>");
            for (TableRow r : this.rows) {
                b.append("<tr>");
                b.append((CharSequence)r.b);
                b.append("</tr>");
            }
            b.append("</table>");
            return b;
        }

        public class TableRow {
            private final StringBuilder b = new StringBuilder();

            public TableRow td(String content) {
                this.b.append("<td>").append(content).append("</td>");
                return this;
            }

            public TableRow th(String header) {
                this.b.append("<th>").append(header).append("</th>");
                return this;
            }

            public Table rowEnd() {
                return Table.this;
            }
        }
    }

    public static enum METHOD {
        GET,
        POST;

    }

    public static class TextAreaInput
    extends Input {
        private final int rows;
        private final int cols;
        private final String name;
        private final String value;

        public TextAreaInput(String name, String value, int cols, int rows) {
            this.name = name;
            this.value = value;
            this.cols = cols;
            this.rows = rows;
        }

        public String toString() {
            return this.name + ": <textarea name=\"" + this.name + "\" cols=\"" + this.cols + "\" rows=\"" + this.rows + "\">" + this.value + "</textarea>";
        }
    }

    public static class TextInput
    extends KeyValueInput {
        private final int size;

        public TextInput(String name, String value) {
            this(name, value, 30);
        }

        public TextInput(String name, String value, int size) {
            super(name, value);
            this.size = size;
        }

        public String toString() {
            return this.name + ": <input" + " type=\"text\"" + " name=\"" + this.name + "\"" + " value=\"" + this.value + "\"" + " size=\"" + this.size + "\"" + "/>";
        }
    }

    public static class FileInput
    extends KeyValueInput {
        private final int size;

        public FileInput(String name, int size) {
            super(name, "");
            this.size = size;
        }

        public String toString() {
            return this.name + ": <input" + " type=\"file\"" + " name=\"" + this.name + "\"" + " value=\"" + this.value + "\"" + " size=\"" + this.size + "\"" + "/>";
        }
    }

    public static class HiddenInput
    extends KeyValueInput {
        public HiddenInput(String name, String value) {
            super(name, value);
        }

        public String toString() {
            return "<input type=\"hidden\" name=\"" + this.name + "\"" + " value=\"" + this.value + "\"" + "/>";
        }
    }

    static class KeyValueInput
    extends Input {
        protected String name;
        protected String value;

        public KeyValueInput(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class SubmitInput
    extends Input {
        private final String label;

        public SubmitInput(String label) {
            this.label = label;
        }

        public String toString() {
            return "<input type=\"submit\" value=\"" + this.label + "\"/>";
        }
    }

    public static class Input {
    }
}

