/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.logical;

import de.xam.dwzmodel.graph.JsonFields;
import de.xam.dwzmodel.graph.LinkBaseType;
import de.xam.dwzmodel.graph.logical.LogicalEntity;
import de.xam.dwzmodel.graph.logical.LogicalGraph;
import de.xam.dwzmodel.graph.logical.LogicalNode;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.Items;
import de.xam.json.JON;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.content.UriFormatter;
import org.xydra.base.XId;
import org.xydra.index.query.ITriple;

public class LogicalLink
extends LogicalEntity {
    private final LinkBaseType type;
    private Object baseEntity;
    private boolean reversed;
    protected JON attributes = JON.create();
    private String label;

    private LogicalLink(LogicalGraph logicalGraph, LinkBaseType type, boolean reversed) {
        super(logicalGraph);
        this.reversed = reversed;
        this.type = type;
        switch (type) {
            case InferredTriple: {
                this.attributes.putString("base", new String[]{JsonFields.LinkBase.inftriple.name()});
                break;
            }
            case Statement: {
                this.attributes.putString("base", new String[]{JsonFields.LinkBase.stmt.name()});
            }
        }
    }

    public LogicalLink(LogicalGraph logicalGraph, ITriple<XId, XId, XId> triple, boolean reversed) {
        this(logicalGraph, LinkBaseType.InferredTriple, reversed);
        this.baseEntity = triple;
    }

    public LogicalLink(LogicalGraph logicalGraph, IStatement stmt, boolean reversed) {
        this(logicalGraph, LinkBaseType.InferredTriple, reversed);
        this.baseEntity = stmt;
    }

    public ITriple<XId, XId, XId> getNormalizedTriple() {
        ITriple<XId, XId, XId> triple = this.asTriple();
        return this.reversed ? LogicalGraph.reverse(triple) : triple;
    }

    @Override
    public JON getJsonAtts() {
        return this.attributes;
    }

    public XId getStartId() {
        return (XId)this.getNormalizedTriple().s();
    }

    public XId getEndId() {
        return (XId)this.getNormalizedTriple().o();
    }

    public int hashCode() {
        return this.baseEntity.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LogicalLink) {
            return this.baseEntity.equals(((LogicalLink)other).baseEntity);
        }
        return false;
    }

    public ITriple<XId, XId, XId> getTriple() {
        assert (this.type == LinkBaseType.InferredTriple);
        return (ITriple)this.baseEntity;
    }

    public IStatement getStatement() {
        assert (this.type == LinkBaseType.Statement);
        return (IStatement)this.baseEntity;
    }

    public ITriple<XId, XId, XId> asTriple() {
        switch (this.type) {
            case InferredTriple: {
                return this.getTriple();
            }
            case Statement: {
                return this.getStatement().getTriple();
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        String linkBaseStr = (Object)((Object)this.type) + ": " + this.baseEntity;
        return "[LINK] " + linkBaseStr + " reversed?" + this.reversed;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    private String getLabel(IMyBase myBase) {
        switch (this.type) {
            case InferredTriple: {
                XId p = (XId)this.getTriple().p();
                String s = Items.getDisplayString((IItemSet)myBase.itemSet(), (XId)p);
                return s;
            }
            case Statement: {
                XId p = (XId)this.asTriple().p();
                String s = Items.getDisplayString((IItemSet)myBase.itemSet(), (XId)p);
                return s;
            }
        }
        throw new AssertionError();
    }

    public LinkBaseType getLinkBaseType() {
        return this.type;
    }

    public void setReversed(boolean b) {
        this.reversed = b;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        IMyBase myBase = this.getGraph().getMyBase();
        String s = this.getLabel(myBase);
        assert (s != null) : "found no label for " + this;
        return UriFormatter.toShortAndRelevantString((String)s, this.getGraph().getNamespaces(), (boolean)true);
    }

    public void setReversed(String label) {
        this.reversed = true;
        this.label = label;
    }

    public LogicalNode getStart() {
        return this.getGraph().getNode(this.getStartId());
    }

    public LogicalNode getEnd() {
        return this.getGraph().getNode(this.getEndId());
    }

    public LogicalNode getOtherEnd(XId nodeId) {
        if (this.getStartId().equals((Object)nodeId)) {
            return this.getEnd();
        }
        assert (this.getEndId().equals((Object)nodeId));
        return this.getStart();
    }
}

