/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.visual;

import de.xam.dwzmodel.graph.GraphJob;
import de.xam.dwzmodel.graph.VisualType;
import de.xam.dwzmodel.graph.logical.LogicalNode;
import de.xam.dwzmodel.graph.visual.GraphTriplePattern;
import de.xam.dwzmodel.graph.visual.ICaptionEntry;
import de.xam.dwzmodel.graph.visual.IVisualLink;
import de.xam.dwzmodel.graph.visual.IVisualNode;
import de.xam.dwzmodel.graph.visual.VisualGraphs;
import de.xam.dwzmodel.graph.visual.VisualNodes;
import de.xam.dwzmodel.graph.visual.impl.VisualFactory;
import de.xam.dwzmodel.graph.visual.impl.VisualGraph;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.json.JON;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.content.UriFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.CountingMap;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.query.ITriple;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class GraphSimplifier {
    private static final Logger log = LoggerFactory.getLogger(GraphSimplifier.class);

    public static void simplify(final IMyBase myBase, GraphJob job, VisualGraph visualGraph) {
        MapSetIndex pattern2memberLinks = MapSetIndex.createWithSmallEntrySets();
        final CountingMap patternCounts = new CountingMap();
        for (IVisualLink visualLink : visualGraph.getLinks()) {
            ITriple<XId, XId, XId> triple = visualLink.getLogicalLink().asTriple();
            XId s = (XId)triple.s();
            XId p = (XId)triple.p();
            XId o = (XId)triple.o();
            XId pInv = MyBases.getSingleInverse((IMyBase)myBase, (XId)p);
            GraphTriplePattern xpoPattern = new GraphTriplePattern(p, o);
            pattern2memberLinks.index((Object)xpoPattern, (Object)visualLink);
            patternCounts.index((Object)xpoPattern);
            if (pInv == null) continue;
            GraphTriplePattern xpinvsPattern = new GraphTriplePattern(pInv, s);
            pattern2memberLinks.index((Object)xpinvsPattern, (Object)visualLink);
            patternCounts.index((Object)xpinvsPattern);
        }
        ArrayList mostUsedPatterns = new ArrayList();
        mostUsedPatterns.addAll(patternCounts.keySet());
        Collections.sort(mostUsedPatterns, new Comparator<GraphTriplePattern>(){

            @Override
            public int compare(GraphTriplePattern a, GraphTriplePattern b) {
                return (Integer)patternCounts.getCount((Object)b) - (Integer)patternCounts.getCount((Object)a);
            }
        });
        int pickedPatterns = 0;
        MapSetIndex caption2members = MapSetIndex.createWithFastEntrySets();
        HashSet<IVisualNode> potentiallyOrphanedNodes = new HashSet<IVisualNode>();
        Iterator patternsIt = mostUsedPatterns.iterator();
        while (patternsIt.hasNext() && pickedPatterns < job.maxNodeTypes) {
            int requiredMinMembers;
            GraphTriplePattern pattern = (GraphTriplePattern)patternsIt.next();
            int memberCount = (Integer)patternCounts.getCount((Object)pattern);
            int n = requiredMinMembers = pattern.isTypePattern() ? job.minNodeTypeMembers : job.minNodePatternMembers;
            if (memberCount < requiredMinMembers) break;
            Set visualLinksInPattern = pattern2memberLinks.lookup((Object)pattern).toSet();
            int typenumber = pickedPatterns + 1;
            String patternCssClass = "type" + typenumber;
            boolean foundNodeMemberOfAnotherPattern = false;
            for (IVisualLink visualLinkInPattern : visualLinksInPattern) {
                LogicalNode otherEnd = visualLinkInPattern.getLogicalLink().getOtherEnd(pattern.o);
                IVisualNode rootNode = visualGraph.getVisualByLogicalNode(otherEnd);
                if (!VisualNodes.isMarked(rootNode)) continue;
                foundNodeMemberOfAnotherPattern = true;
                break;
            }
            if (foundNodeMemberOfAnotherPattern) continue;
            ++pickedPatterns;
            ICaptionEntry caption = VisualFactory.createCaptionEntry(VisualType.Node);
            caption.getJON().putInt("typenumber", new Integer[]{typenumber});
            IItem patternRelItem = myBase.itemSet().getItemById(pattern.p);
            assert (patternRelItem != null) : "found no item for '" + pattern.p + "'";
            IItem patternNodeItem = myBase.itemSet().getItemById(pattern.o);
            String prettyRelLabel = visualGraph.getLogicalGraph().toDisplayString(patternRelItem);
            String prettyNodeLabel = visualGraph.getLogicalGraph().toDisplayString(patternNodeItem);
            caption.setLabel("= " + prettyRelLabel + ": " + prettyNodeLabel);
            caption.setLinkedId(patternNodeItem.getId());
            JON.addCssClasses((JON)caption.getJON(), (String)"class", (String[])new String[]{patternCssClass});
            visualGraph.getCaptions().add(caption);
            for (IVisualLink visualLinkInPattern : visualLinksInPattern) {
                IVisualNode nodePartOfPattern;
                IVisualNode nodeMemberOfPattern;
                if (log.isTraceEnabled()) {
                    log.trace("remove link represented by node styling now " + visualLinkInPattern);
                }
                visualGraph.removeLink(visualLinkInPattern);
                XId patternNodeId = pattern.o;
                if (visualLinkInPattern.getStart().getLogicalNodes().contains(patternNodeId)) {
                    nodeMemberOfPattern = visualLinkInPattern.getEnd();
                    nodePartOfPattern = visualLinkInPattern.getStart();
                } else {
                    assert (visualLinkInPattern.getEnd().getLogicalNodes().contains(patternNodeId));
                    nodeMemberOfPattern = visualLinkInPattern.getStart();
                    nodePartOfPattern = visualLinkInPattern.getEnd();
                }
                VisualNodes.setMarked(nodeMemberOfPattern, true);
                nodeMemberOfPattern.getJsonAttributes().putInt("typenumber", new Integer[]{typenumber});
                nodeMemberOfPattern.getCssClasses().add(patternCssClass);
                potentiallyOrphanedNodes.add(nodePartOfPattern);
                caption2members.index((Object)caption, (Object)nodeMemberOfPattern);
            }
        }
        for (IVisualNode nodePartOfPattern : potentiallyOrphanedNodes) {
            Set<IVisualLink> usedLinks = visualGraph.getLinksConnectedTo(nodePartOfPattern);
            if (usedLinks.size() != 0 || VisualNodes.isMarked(nodePartOfPattern)) continue;
            if (log.isTraceEnabled()) {
                log.trace("remove orphaned node " + nodePartOfPattern);
            }
            visualGraph.removeNode(nodePartOfPattern);
        }
        if (visualGraph.getNodeCount() > job.maxNodes) {
            List<IVisualNode> boringList = visualGraph.sortMostBoringNodesFirst();
            int i = 0;
            while (visualGraph.getNodeCount() > job.maxNodes) {
                IVisualNode boringNode = boringList.get(i);
                ++i;
                visualGraph.removeNode(boringNode);
            }
        }
        ArrayList<ICaptionEntry> captions = new ArrayList<ICaptionEntry>(visualGraph.getCaptions());
        for (ICaptionEntry ce : captions) {
            IEntrySet entry = caption2members.lookup((Object)ce);
            int count = 0;
            if (entry != null) {
                for (IVisualNode member : entry.toSet()) {
                    if (!visualGraph.containsNode(member)) continue;
                    ++count;
                }
            }
            if (count != 0) continue;
            visualGraph.getCaptions().remove(ce);
        }
        MapSetIndex linkUsage = MapSetIndex.createWithFastEntrySets();
        for (IVisualLink visualLink : visualGraph.getLinks()) {
            XId p = (XId)visualLink.getLogicalLink().asTriple().p();
            linkUsage.index((Object)p, (Object)visualLink);
            XId pInv = MyBases.getSingleInverse((IMyBase)myBase, (XId)p);
            if (pInv == null) continue;
            linkUsage.index((Object)pInv, (Object)visualLink);
        }
        ArrayList list = new ArrayList();
        list.addAll(linkUsage.getEntries());
        Collections.sort(list, new Comparator<Map.Entry<XId, IEntrySet<IVisualLink>>>(){

            @Override
            public int compare(Map.Entry<XId, IEntrySet<IVisualLink>> a, Map.Entry<XId, IEntrySet<IVisualLink>> b) {
                int i = b.getValue().size() - a.getValue().size();
                if (i != 0) {
                    return i;
                }
                XId relA = a.getKey();
                XId relB = b.getKey();
                double d = VisualGraphs.getRelationPreference(relB) - VisualGraphs.getRelationPreference(relA);
                i = (int)Math.signum(d);
                if (i != 0) {
                    return i;
                }
                String labelA = ItemSets.getContent((IItemSet)myBase.itemSet(), (XId)relA);
                String labelB = ItemSets.getContent((IItemSet)myBase.itemSet(), (XId)relB);
                return labelA.length() - labelB.length();
            }
        });
        int pickedLinkTypes = 0;
        HashSet<XId> pickedLinkTypeIds = new HashSet<XId>();
        for (Map.Entry entry : list) {
            Set memberLinks;
            if (pickedLinkTypes == job.maxLinkTypes) break;
            XId p = (XId)entry.getKey();
            if (pickedLinkTypeIds.contains(p) || (memberLinks = ((IEntrySet)entry.getValue()).toSet()).size() < job.minLinkTypeMembers) continue;
            pickedLinkTypeIds.add(p);
            XId pInv = MyBases.getSingleInverse((IMyBase)myBase, (XId)p);
            String reverseLabel = ItemSets.getContent((IItemSet)myBase.itemSet(), (XId)p);
            if (pInv != null) {
                pickedLinkTypeIds.add(pInv);
            }
            int typeNumber = pickedLinkTypes + 1;
            ICaptionEntry linkCaption = VisualFactory.createCaptionEntry(VisualType.Link);
            String rawLinkLabel = ItemSets.getContent((IItemSet)myBase.itemSet(), (XId)p);
            Map<String, String> nsMap = visualGraph.getLogicalGraph().getNamespaces();
            String prettyLinkLabel = UriFormatter.toShortAndRelevantString((String)rawLinkLabel, nsMap, (boolean)true);
            linkCaption.setLabel(prettyLinkLabel);
            linkCaption.setLinkedId(p);
            String cssClass = "type" + typeNumber;
            linkCaption.getJON().putInt("typenumber", new Integer[]{typeNumber});
            linkCaption.getJON().putString("class", new String[]{cssClass});
            visualGraph.getCaptions().add(linkCaption);
            for (IVisualLink link : memberLinks) {
                link.getJsonAttributes().putInt("typenumber", new Integer[]{typeNumber});
                link.getCssClasses().add(cssClass);
                XId linkP = (XId)link.getLogicalLink().asTriple().p();
                if (linkP.equals((Object)p)) continue;
                assert (pInv != null) : "found no inverse of p '" + p + "' while at " + link;
                assert (linkP.equals((Object)pInv)) : "linkP=" + linkP + " == pInv=" + pInv;
                link.getLogicalLink().setReversed(reverseLabel);
            }
            ++pickedLinkTypes;
        }
    }
}

