/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.visual.impl;

import de.xam.dwzmodel.graph.logical.LogicalGraph;
import de.xam.dwzmodel.graph.logical.LogicalNode;
import de.xam.dwzmodel.graph.visual.ICaptionEntry;
import de.xam.dwzmodel.graph.visual.IVisualGraph;
import de.xam.dwzmodel.graph.visual.IVisualLink;
import de.xam.dwzmodel.graph.visual.IVisualNode;
import de.xam.dwzmodel.graph.visual.VisualNodes;
import de.xam.dwzmodel.graph.visual.impl.VisualFactory;
import de.xam.json.JON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.index.impl.MapMapSetIndex;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.ITriple;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class VisualGraph
implements IVisualGraph {
    private static final Logger log = LoggerFactory.getLogger(VisualGraph.class);
    private final List<ICaptionEntry> captionEntries = new ArrayList<ICaptionEntry>();
    private final Set<IVisualNode> centralNodes = new HashSet<IVisualNode>();
    private transient Map<LogicalNode, IVisualNode> logical2visualNode = new HashMap<LogicalNode, IVisualNode>();
    private final Set<IVisualLink> links = new HashSet<IVisualLink>();
    private final LogicalGraph logicalGraph;
    private final Set<IVisualNode> nodes = new HashSet<IVisualNode>();
    transient MapMapSetIndex<IVisualNode, XId, IVisualLink> s_p_2link = MapMapSetIndex.createWithSmallSets();

    public VisualGraph(LogicalGraph logicalGraph) {
        this.logicalGraph = logicalGraph;
    }

    public boolean addLink(IVisualLink visualLink) {
        ITriple<XId, XId, XId> triple;
        IVisualNode startNode = visualLink.getStart();
        boolean success = this.s_p_2link.index((Object)startNode, (triple = visualLink.getLogicalLink().asTriple()).p(), (Object)visualLink);
        if (success) {
            this.links.add(visualLink);
        }
        return success;
    }

    public boolean containsNode(IVisualNode node) {
        return this.nodes.contains(node);
    }

    public IVisualNode createAndAddNode(LogicalNode logicalNode, JON jsonAtts) {
        IVisualNode node = VisualFactory.createVisualNode(this, logicalNode, jsonAtts);
        this.nodes.add(node);
        IVisualNode v = this.logical2visualNode.get(logicalNode);
        if (v == null) {
            this.logical2visualNode.put(logicalNode, node);
        } else {
            log.warn("HE? " + logicalNode);
        }
        return node;
    }

    @Override
    public List<ICaptionEntry> getCaptions() {
        return this.captionEntries;
    }

    public Set<IVisualNode> getCentralNodes() {
        return this.centralNodes;
    }

    @Override
    public Iterable<IVisualLink> getLinks() {
        return this.links;
    }

    public Set<IVisualLink> getLinksConnectedTo(final IVisualNode node) {
        Set links = Iterators.toSet((Iterator)Iterators.filter(this.getLinks().iterator(), (IFilter)new IFilter<IVisualLink>(){

            public boolean matches(IVisualLink link) {
                return link.getStart().equals(node) || link.getEnd().equals(node);
            }
        }));
        return links;
    }

    public LogicalGraph getLogicalGraph() {
        return this.logicalGraph;
    }

    @Override
    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public Iterable<IVisualNode> getNodes() {
        return this.nodes;
    }

    public boolean removeLink(IVisualLink visualLink) {
        ITriple<XId, XId, XId> t;
        assert (this.logical2visualNode.values().contains(visualLink.getStart())) : "Link.start not found (" + visualLink.getStart() + ") start of " + visualLink;
        assert (this.logical2visualNode.values().contains(visualLink.getEnd())) : "found no end of " + visualLink;
        IVisualNode startNode = visualLink.getStart();
        boolean success = this.s_p_2link.deIndex((Object)startNode, (t = visualLink.getLogicalLink().asTriple()).p(), (Object)visualLink);
        if (success) {
            this.links.remove(visualLink);
        }
        return success;
    }

    public void removeNode(IVisualNode node) {
        HashSet<IVisualLink> toBeRemoved = new HashSet<IVisualLink>();
        for (IVisualLink visualLink : this.getLinks()) {
            if (!visualLink.getStart().equals(node) && !visualLink.getEnd().equals(node)) continue;
            toBeRemoved.add(visualLink);
        }
        for (IVisualLink visualLink : toBeRemoved) {
            this.removeLink(visualLink);
        }
        this.nodes.remove(node);
        this.logical2visualNode.remove(node.getLogicalNodes());
    }

    public List<IVisualNode> sortMostBoringNodesFirst() {
        this.updateLinkCounts();
        ArrayList<IVisualNode> list = new ArrayList<IVisualNode>(this.nodes.size());
        list.addAll(this.nodes);
        Collections.sort(list, new Comparator<IVisualNode>(){

            @Override
            public int compare(IVisualNode a, IVisualNode b) {
                int markA = VisualNodes.isMarked(a) ? 1 : 0;
                int markB = VisualNodes.isMarked(b) ? 1 : 0;
                int i = a.getLinkCount() + markA - (b.getLinkCount() + markB);
                if (i != 0) {
                    return i;
                }
                return 0;
            }
        });
        return list;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("=== VisualGraph\n");
        b.append("central: " + this.getCentralNodes() + "\n");
        b.append("id2node: ");
        for (Map.Entry<LogicalNode, IVisualNode> e : this.logical2visualNode.entrySet()) {
            b.append("\n  " + e.getKey() + " -> " + e.getValue().getPrimaryLogicalNode().getBaseEntity().getId() + " ");
        }
        b.append("\n");
        b.append("nodes: ");
        for (IVisualNode visualNode : this.getNodes()) {
            b.append("\n" + visualNode.toString());
        }
        b.append("\n");
        b.append("links: ");
        for (IVisualLink visualLink : this.getLinks()) {
            b.append("\n" + visualLink.toString());
        }
        return b.toString();
    }

    void updateLinkCounts() {
        for (IVisualNode node : this.getNodes()) {
            node.setLinkCount(0);
        }
        for (IVisualLink link : this.links) {
            IVisualNode start = link.getStart();
            start.setLinkCount(start.getLinkCount() + 1);
            IVisualNode end = link.getEnd();
            end.setLinkCount(end.getLinkCount() + 1);
        }
    }

    public IVisualNode getVisualByLogicalNode(LogicalNode logicalNode) {
        IVisualNode visualNode = this.logical2visualNode.get(logicalNode);
        return visualNode;
    }
}

