/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.logical;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.Sets;
import de.xam.dwzmodel.graph2.logical.LogicalLinkContainer;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.mybase.model.api.IMyBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.base.XId;
import org.xydra.index.impl.TripleUtils;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.ITriple;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LogicalGraph {
    private static final Logger log = LoggerFactory.getLogger(LogicalGraph.class);
    private final SortedSet<LogicalNode> centralNodes;
    private final SortedSet<LogicalNode> desiredNodes;
    private final Set<LogicalNode> fullyExploredNodes;
    private final Map<XId, LogicalNode> id2logicalNode = new HashMap<XId, LogicalNode>();
    private final IMyBase myBase;

    private static boolean exploreFrontier_1_Node(LogicalGraph logicalGraph, LogicalNode frontierNode, int maxDepth, int maxTotalNodes, Set<LogicalNode> nextFrontier) {
        XId entityId = frontierNode.getItemId();
        log.trace("Explore node " + entityId);
        int depth = frontierNode.getDepth();
        if (maxDepth != -1 && depth >= maxDepth) {
            return false;
        }
        if (maxTotalNodes != -1 && logicalGraph.getFullyExploredNodeCount() >= maxTotalNodes) {
            return false;
        }
        ExplorationResult nodeResult = ExplorationResult.createNothingFoundFullyExplored();
        Iterator forwardIt = logicalGraph.myBase.infModel().getTriples(entityId, null, null);
        while (forwardIt.hasNext()) {
            ITriple triple = (ITriple)forwardIt.next();
            log.trace("  Explore fwd " + triple);
            ExplorationResult linkResult = LogicalGraph.exploreFrontier_2_Link(logicalGraph, frontierNode, (ITriple<XId, XId, XId>)triple, depth, maxTotalNodes, false, nextFrontier);
            nodeResult.updateWith(linkResult);
        }
        Iterator backwardIt = logicalGraph.myBase.infModel().getTriples(null, null, entityId);
        while (backwardIt.hasNext()) {
            ITriple triple = (ITriple)backwardIt.next();
            log.trace("  Explore bck " + triple);
            ExplorationResult linkResult = LogicalGraph.exploreFrontier_2_Link(logicalGraph, frontierNode, (ITriple<XId, XId, XId>)triple, depth, maxTotalNodes, true, nextFrontier);
            nodeResult.updateWith(linkResult);
        }
        if (nodeResult.fullyExplored) {
            logicalGraph.fullyExploredNodes.add(frontierNode);
        }
        return nodeResult.foundMoreLinks;
    }

    private static ExplorationResult exploreFrontier_2_Link(LogicalGraph logicalGraph, LogicalNode frontierNode, ITriple<XId, XId, XId> triple, int depth, int maxTotalNodes, boolean backwards, Set<LogicalNode> nextFrontier) {
        LogicalLinkContainer link;
        XId otherEndId = (XId)TripleUtils.getOtherEnd((Object)frontierNode.getItemId(), triple);
        LogicalNode otherEndNode = logicalGraph.id2logicalNode.get(otherEndId);
        if (otherEndNode == null) {
            if (maxTotalNodes != -1 && logicalGraph.getFullyExploredNodeCount() >= maxTotalNodes) {
                return ExplorationResult.createNothingFoundAndNothingExplored();
            }
            otherEndNode = logicalGraph.getOrCreateLogicalNode(otherEndId, depth + 1);
            nextFrontier.add(otherEndNode);
        }
        boolean newLink = false;
        if (backwards) {
            link = frontierNode.getIncomingLinkFrom(otherEndNode);
            if (link == null) {
                LogicalGraph.indexLogicalLink(otherEndNode, (XId)triple.p(), frontierNode);
                newLink = true;
            } else {
                newLink = link.addRelationType((XId)triple.p());
            }
        } else {
            link = frontierNode.getOutgoingLinkTo(otherEndNode);
            if (link == null) {
                LogicalGraph.indexLogicalLink(frontierNode, (XId)triple.p(), otherEndNode);
                newLink = true;
            } else {
                newLink = link.addRelationType((XId)triple.p());
            }
        }
        ExplorationResult ler = new ExplorationResult(newLink, true);
        return ler;
    }

    public LogicalGraph(IMyBase myBase, SortedSet<XId> centralItemIds, SortedSet<XId> desiredItemIds) {
        LogicalNode logicalNode;
        this.myBase = myBase;
        this.centralNodes = new TreeSet<LogicalNode>();
        this.desiredNodes = new TreeSet<LogicalNode>();
        this.fullyExploredNodes = new HashSet<LogicalNode>();
        for (XId centralId : centralItemIds) {
            logicalNode = this.getOrCreateLogicalNode(centralId, 0);
            this.centralNodes.add(logicalNode);
        }
        for (XId desiredId : desiredItemIds) {
            logicalNode = this.getOrCreateLogicalNode(desiredId, 0);
            this.desiredNodes.add(logicalNode);
        }
    }

    public boolean containsNode(LogicalNode node) {
        return this.id2logicalNode.containsKey(node.getItemId());
    }

    public void copyLinksFrom(LogicalGraph fromLogicalGraph, int depth) {
        for (LogicalLinkContainer fromLink : Iterators.from(fromLogicalGraph.getOutgoingLinks())) {
            XId sourceId = fromLink.getSource().getItemId();
            XId targetId = fromLink.getTarget().getItemId();
            if (!this.id2logicalNode.containsKey(sourceId) || !this.id2logicalNode.containsKey(targetId)) continue;
            LogicalNode source = this.getOrCreateLogicalNode(sourceId, depth);
            LogicalNode target = this.getOrCreateLogicalNode(targetId, depth);
            for (XId p : fromLink.getRelationTypes()) {
                LogicalGraph.indexLogicalLink(source, p, target);
            }
        }
    }

    public Set<LogicalNode> createInitialFrontier() {
        HashSet<LogicalNode> frontierNodes = new HashSet<LogicalNode>();
        frontierNodes.addAll(this.getCentralNodes());
        frontierNodes.addAll(this.getDesiredNodes());
        return frontierNodes;
    }

    public Set<LogicalNode> exploreFrontier_old(Set<LogicalNode> currentFrontier, int maxDepth, int maxTotalNodes) {
        boolean exploreMore = true;
        HashSet lastFrontier = Sets.newHashSet(currentFrontier);
        HashSet nextFrontier = Sets.newHashSet();
        while (exploreMore) {
            exploreMore = false;
            log.trace("Frontier: " + lastFrontier);
            for (LogicalNode frontierNode : lastFrontier) {
                exploreMore |= LogicalGraph.exploreFrontier_1_Node(this, frontierNode, maxDepth, maxTotalNodes, nextFrontier);
            }
            lastFrontier = Sets.newHashSet((Iterable)nextFrontier);
            nextFrontier.clear();
        }
        return nextFrontier;
    }

    public Set<LogicalNode> exploreFrontier_v2(Set<LogicalNode> currentFrontier, int maxDepth, int maxTotalNodes) {
        boolean exploreMore = true;
        HashSet lastFrontier = Sets.newHashSet(currentFrontier);
        HashSet nextFrontier = Sets.newHashSet();
        while (exploreMore) {
            exploreMore = false;
            log.trace("Frontier: " + lastFrontier);
            for (LogicalNode frontierNode : lastFrontier) {
                exploreMore |= LogicalGraph.exploreFrontier_1_Node(this, frontierNode, maxDepth, maxTotalNodes, nextFrontier);
            }
            lastFrontier = Sets.newHashSet((Iterable)nextFrontier);
            nextFrontier.clear();
        }
        return nextFrontier;
    }

    public SortedSet<LogicalNode> getCentralNodes() {
        return this.centralNodes;
    }

    public SortedSet<LogicalNode> getDesiredNodes() {
        return this.desiredNodes;
    }

    public int getFullyExploredNodeCount() {
        return this.fullyExploredNodes.size();
    }

    public Iterator<LogicalLinkContainer> getOutgoingLinks() {
        return Iterators.cascade(this.id2logicalNode.values().iterator(), (ITransformer)new ITransformer<LogicalNode, Iterator<LogicalLinkContainer>>(){

            public Iterator<LogicalLinkContainer> transform(LogicalNode in) {
                return in.getOutgoingLinks().iterator();
            }
        });
    }

    public IMyBase getMyBase() {
        return this.myBase;
    }

    public LogicalNode getNodeById(XId itemId) {
        return this.id2logicalNode.get(itemId);
    }

    public int getNodeCount() {
        return this.id2logicalNode.values().size();
    }

    public Iterable<LogicalNode> getNodes() {
        return this.id2logicalNode.values();
    }

    private LogicalNode getOrCreateLogicalNode(XId itemId, int depth) {
        LogicalNode logicalNode = this.id2logicalNode.get(itemId);
        if (logicalNode == null) {
            logicalNode = new LogicalNode(this, itemId, depth);
            this.id2logicalNode.put(itemId, logicalNode);
        } else {
            logicalNode.setDepth(Math.min(logicalNode.getDepth(), depth));
        }
        return logicalNode;
    }

    private static void indexLogicalLink(LogicalNode source, XId p, LogicalNode target) {
        if (log.isTraceEnabled()) {
            log.trace("Index link [" + source.getItemId() + "]-[" + p + "]->[" + target.getItemId() + "]");
        }
        if (source.equals(target)) {
            source.indexSelfLink(p);
        } else {
            source.indexOutgoingLink(p, target);
            target.indexIncomingLink(source, p);
        }
    }

    public boolean isFullyExplored(LogicalNode logicalNode) {
        return this.fullyExploredNodes.contains(logicalNode);
    }

    public void markFullyExploredNodes(LogicalGraph beforeShrinking) {
        for (LogicalNode node : this.getNodes()) {
            boolean fully = true;
            LogicalNode beforeNode = beforeShrinking.getNodeById(node.getItemId());
            Iterator<LogicalNode> beforeLinkedIt = beforeNode.getLinkedNodes();
            while (beforeLinkedIt.hasNext()) {
                LogicalNode beforeLinked = beforeLinkedIt.next();
                if (this.id2logicalNode.containsKey(beforeLinked.getItemId())) continue;
                fully = false;
                break;
            }
            if (fully) {
                this.fullyExploredNodes.add(node);
                continue;
            }
            log.trace("Remains frontier");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (LogicalNode node : this.getNodes()) {
            b.append(node.toString() + "\n");
        }
        return b.toString();
    }

    public String getStats() {
        return "central=" + this.centralNodes.size() + "; desired=" + this.desiredNodes.size() + "; explored=" + this.fullyExploredNodes.size() + "; total=" + this.id2logicalNode.size();
    }

    public LogicalNode addLogicalNode(LogicalNode logicalNode) {
        LogicalNode node = this.getOrCreateLogicalNode(logicalNode.getItemId(), logicalNode.getDepth());
        if (!logicalNode.isFrontier()) {
            this.fullyExploredNodes.add(node);
        }
        return node;
    }

    public void removeLogicalNode(LogicalNode logicalNode) {
        assert (this.getNodeById(logicalNode.getItemId()) == logicalNode);
        Iterator<LogicalNode> it = logicalNode.getLinkedNodes();
        while (it.hasNext()) {
            LogicalNode targetNode = it.next();
            targetNode.deIndexIncomingLinks(logicalNode);
        }
        this.id2logicalNode.remove(logicalNode.getItemId());
        this.fullyExploredNodes.remove(logicalNode);
        this.centralNodes.remove(logicalNode);
        this.desiredNodes.remove(logicalNode);
    }

    private static class ExplorationResult {
        private boolean foundMoreLinks = false;
        private boolean fullyExplored = false;

        static ExplorationResult createNothingFoundAndNothingExplored() {
            return new ExplorationResult(false, false);
        }

        public static ExplorationResult createNothingFoundFullyExplored() {
            return new ExplorationResult(false, true);
        }

        public ExplorationResult(boolean foundMoreLinks, boolean fullyExplored) {
            this.foundMoreLinks = foundMoreLinks;
            this.fullyExplored = fullyExplored;
        }

        public void updateWith(ExplorationResult subResult) {
            this.foundMoreLinks |= subResult.foundMoreLinks;
            this.fullyExplored &= subResult.fullyExplored;
        }
    }
}

