/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.logical;

import de.xam.dwzmodel.graph2.logical.LogicalEntity;
import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.base.XId;

public class LogicalLinkContainer
extends LogicalEntity
implements Comparable<LogicalLinkContainer> {
    private final SortedSet<XId> relationTypes = new TreeSet<XId>();
    private final LogicalNode source;
    private final LogicalNode target;

    LogicalLinkContainer(LogicalGraph logicalGraph, LogicalNode source, LogicalNode target) {
        super(logicalGraph);
        this.source = source;
        this.target = target;
    }

    public boolean addRelationType(XId p) {
        return this.relationTypes.add(p);
    }

    @Override
    public int compareTo(LogicalLinkContainer o) {
        int i = this.getSource().compareTo(o.getSource());
        if (i != 0) {
            return i;
        }
        i = this.target.compareTo(o.getTarget());
        assert (i != 0);
        return i;
    }

    public boolean equals(Object other) {
        if (other instanceof LogicalLinkContainer) {
            LogicalLinkContainer o = (LogicalLinkContainer)other;
            return this.getSource().equals(o.getSource()) && this.getTarget().equals(o.getTarget());
        }
        return false;
    }

    public LogicalNode getOtherSide(LogicalNode logicalNode) {
        if (logicalNode.equals(this.getSource())) {
            return this.getTarget();
        }
        assert (logicalNode.equals(this.getTarget()));
        return this.getSource();
    }

    public LogicalLinkContainer getInverse() {
        return this.getTarget().getIncomingLinkFrom(this.getSource());
    }

    public Iterable<XId> getRelationTypes() {
        return this.relationTypes;
    }

    public LogicalNode getSource() {
        return this.source;
    }

    public LogicalNode getTarget() {
        return this.target;
    }

    public int hashCode() {
        return this.getSource().hashCode() * this.getTarget().hashCode();
    }

    public boolean isFrontier() {
        return this.getSource().isFrontier() || this.getTarget().isFrontier();
    }

    public String toString() {
        return this.getSource().toString() + "--(" + this.relationTypes + ")-->" + this.getTarget().toString();
    }
}

