/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.import_kgif_110;

import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.IStreamTransformer;
import com.calpano.kgif.io.common.KgifRepairJob;
import com.calpano.kgif.io.common.impl.AutorepairTransformer;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReads;
import com.calpano.kgif.v1_1_0.write.WritingEntityHandler;
import com.google.web.bindery.event.shared.EventBus;
import de.xam.dwzmodel.DwzModel;
import de.xam.dwzmodel.io.ImportResult;
import de.xam.dwzmodel.io.export_to_x.KgifItemSetWriteWithWiki;
import de.xam.dwzmodel.io.import_kgif_110.KgifEntityHandlerDwz;
import de.xam.dwzmodel.io.util.DwzProgressUtils;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IItemSource;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.xydra.ItemSetXy;
import de.xam.kgif.impl.itemset.KgifEntityHandler;
import de.xam.kgif.impl.itemset.KgifItemset;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IMultipartFormDataHandler;

public class Kgif1_1_0Manager {
    private static final Logger log = LoggerFactory.getLogger(Kgif1_1_0Manager.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImportResult readKgif1_1_0_fromSourceToItemSet(IStreamSource kgif1_1_0source, IItemSet itemSet, IoProgressReporter iop) throws IOException {
        iop.reportProgress("Reading KGIF 1.1.0 format");
        ImportResult importResult = new ImportResult();
        IStreamProcessProgressReporter sppr = DwzProgressUtils.createNewStreamProgressReporter((IMultipartFormDataHandler.IProgressReporter)iop);
        try (KgifEntityHandlerDwz keh = new KgifEntityHandlerDwz(itemSet);){
            KgifItemset.readKgif((IStreamSource)kgif1_1_0source, (IEntityHandler)keh, (IStreamProcessProgressReporter)sppr);
            Header header = keh.getHeader();
            if (header == null) {
                log.warn("Found no mandatory header in KGIF file -- could not import name-spaces");
            } else {
                Metadata fileMetadata = header.getMetadata();
                String sourceFileName = KgifReads.getMetadataAttribute((Metadata)fileMetadata, (String)"sourceFilename");
                log.info("Loaded KGIF with initial source file '" + sourceFileName + "'");
                Map nsMap = KgifEntityHandler.getNamespaceMap((Header)header);
                for (Map.Entry e : nsMap.entrySet()) {
                    ItemSets.registerNamespace((IItemSet)itemSet, (String)((String)e.getKey()), (String)((String)e.getValue()));
                }
            }
            importResult.itemsWithWikiContent = keh.getItemsToBeParsed();
            importResult.success = true;
            ImportResult importResult2 = importResult;
            return importResult2;
        }
        catch (KgifReadWriteException e) {
            log.warn("Failed to parse ", (Throwable)e);
            iop.reportProgress("Could not read as KGIF 1.1.0. Problem: " + e.getMessage());
            iop.reportException((Throwable)e);
            throw new IOException(e);
        }
    }

    public static IStreamTransformer createRepairTransformer() {
        KgifRepairJob repairJob = new KgifRepairJob();
        repairJob.setCreateMissingNodeLabels(true);
        repairJob.setEnforceValidXML10(true);
        AutorepairTransformer transformer = new AutorepairTransformer(repairJob);
        return transformer;
    }

    public static void sortByChangeDate(IStreamSource source, IStreamSink sink, IoProgressReporter iop) throws IOException {
        iop.reportProgress("Sorting KGIF file by entity change date ...");
        try {
            EventBus eventBus = MyBaseImpl.createEventBus();
            ItemSetXy itemSet = ItemSetXy.createWithoutInference((EventBus)eventBus);
            Kgif1_1_0Manager.readKgif1_1_0_fromSourceToItemSet(source, (IItemSet)itemSet, iop);
            iop.reportProgress("Sorting and Writing ...");
            Writer writer = sink.openWriter();
            WritingEntityHandler weh = new WritingEntityHandler(writer);
            KgifItemSetWriteWithWiki kisw = new KgifItemSetWriteWithWiki();
            String fileCreationHeaderString = Kgif1_1_0Manager.class.getName() + "-createSortedFile";
            kisw.writeKGIF((IItemSet)itemSet, (IEntityHandler)weh, fileCreationHeaderString);
            weh.close();
            writer.close();
        }
        catch (IOException e) {
            throw new IOException("While streaming from " + source.getSourceName() + " to " + sink.getSinkName(), e);
        }
    }

    public static ImportResult readValidSortedKgif1_1_0fromSourceIntoMyBase(IStreamSource source, IMyBase myBase, IoProgressReporter iop) throws IOException {
        try {
            final ImportResult importResult = Kgif1_1_0Manager.readKgif1_1_0_fromSourceToItemSet(source, myBase.itemSet(), iop);
            if (importResult.success) {
                DwzModel.parseWikiContent(new IItemSource(){

                    public Iterator<IItem> items() {
                        return importResult.itemsWithWikiContent.iterator();
                    }

                    public long itemCount() {
                        return importResult.itemsWithWikiContent.size();
                    }
                }, myBase, iop);
            }
            return importResult;
        }
        catch (IOException e) {
            log.warn("Failed to parse " + source.getSourceName(), (Throwable)e);
            throw e;
        }
    }
}

