/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.util;

import de.xam.mybase.model.IoProgressReporter;
import java.io.IOException;
import java.io.InputStream;

public class ReportingImportStream
extends InputStream {
    private final IoProgressReporter iop;
    private final InputStream is;
    private long totalBytes;
    private long lastReportedMb;
    private long expectedSize = -1L;

    public ReportingImportStream(IoProgressReporter iop, InputStream is) {
        this.iop = iop;
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int byteCount = this.is.read();
        this.progress(byteCount);
        return byteCount;
    }

    private void progress(int byteCount) {
        long mb;
        if (byteCount >= 0) {
            this.totalBytes += (long)byteCount;
        }
        if ((mb = this.totalBytes / 0x100000L) > this.lastReportedMb) {
            this.lastReportedMb = mb;
            this.iop.reportProgress("Read " + mb + " MB" + (this.expectedSize == -1L ? "/Unknown" : "/" + this.expectedSize / 0x100000L + " MB"));
        }
    }

    public int hashCode() {
        return this.is.hashCode();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int byteCount = this.is.read(b);
        this.progress(byteCount);
        return byteCount;
    }

    public boolean equals(Object obj) {
        return this.is.equals(obj);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int byteCount = this.is.read(b, off, len);
        this.progress(byteCount);
        return byteCount;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public String toString() {
        return this.is.toString();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void setExpectedSize(long lengthInBytes) {
        this.expectedSize = lengthInBytes;
    }
}

