/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared;

import de.xam.p13n.shared.MissingMessageKeys;
import de.xam.p13n.shared.P13nSearchUtils;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.SharedP13nUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xydra.base.minio.MiniBufferedReader;
import org.xydra.base.minio.MiniIOException;
import org.xydra.base.minio.MiniReader;
import org.xydra.base.minio.MiniStringReader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;

public class PersonalisedMessageBundle
implements Map<String, String>,
Serializable {
    private static Logger log = LoggerFactory.getLogger(PersonalisedMessageBundle.class);
    public static final String MSG_FILE_EXTENSION = "utf8";
    public static final String MSG_FILE_NAME_PREFIX = "MSG";
    private static final long serialVersionUID = -5677588162410333376L;
    private static final String KEY_P13N = "_p13n";
    public static final String KEY_VERSIONHASH = "_version";
    public static final String KEY_TYPE = "_type";
    public static boolean SHOW_MISSING_KEYS_IN_UI = true;
    private Map<String, String> map = new HashMap<String, String>();
    private transient Personalisation p13n;
    private transient String[] packageNames;
    private transient String hash;

    public static Stack<String> getFromGeneralToSpecific(String packageName, Personalisation p13n) {
        return P13nSearchUtils.getFromGeneralToSpecific(packageName, p13n, MSG_FILE_NAME_PREFIX, MSG_FILE_EXTENSION);
    }

    public static String moveOneFolderUp(String classOrPackageName) {
        if (!classOrPackageName.contains("/")) {
            throw new IllegalArgumentException("'" + classOrPackageName + "' does not contain a '/'");
        }
        int last = classOrPackageName.lastIndexOf(47);
        return classOrPackageName.substring(0, last);
    }

    protected PersonalisedMessageBundle() {
    }

    public PersonalisedMessageBundle(Personalisation p13n, String ... packageNames) {
        assert (p13n != null);
        this.p13n = p13n;
        this.map.put(KEY_P13N, p13n.toCompactString());
        this.packageNames = packageNames;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Iterator<String> getRawKeys() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PersonalisedMessageBundle)) {
            return false;
        }
        PersonalisedMessageBundle otherPMB = (PersonalisedMessageBundle)other;
        return this.map.equals(otherPMB.map);
    }

    public String getHash() {
        if (this.hash == null) {
            this.hash = "" + this.map.hashCode();
        }
        return this.hash;
    }

    @Override
    public String get(Object keyObject) {
        String value = null;
        String key = (String)keyObject;
        if (this.map.containsKey(key)) {
            value = this.map.get(key);
        } else {
            MissingMessageKeys.put(key, this);
            log.warn("Missing message key '" + key + "' requested. Stop your debugger here and inspect the this.uber object of Velocity.");
            if (SHOW_MISSING_KEYS_IN_UI) {
                return "???(" + key + ")";
            }
        }
        if (SharedP13nUtils.isDebugger(this.getPersonalisation())) {
            value = PersonalisedMessageBundle.debugMode(key, value);
        }
        if (value != null && SharedP13nUtils.isLoremIpsum(this.getPersonalisation())) {
            value = SharedP13nUtils.loremIpsum(value);
        }
        return value;
    }

    private static String debugMode(String key, String value) {
        if (value == null) {
            return "[" + key + "(missing)]";
        }
        return value + " [" + key + "]";
    }

    public Object[] getKeys() {
        log.warn("ALARM! A call to getKeys. The result is incomplete and contains only those keys added by previous calls.");
        ArrayList<String> list = new ArrayList<String>(this.map.keySet());
        return list.toArray(new String[this.map.keySet().size()]);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode() + this.p13n.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public String put(String arg0, String arg1) {
        return this.map.put(arg0, arg1);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> arg0) {
        this.map.putAll(arg0);
    }

    @Override
    public String remove(Object arg0) {
        return this.map.remove(arg0);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.p13n.toClassifier(3) + " in packages " + PersonalisedMessageBundle.toString(this.packageNames);
    }

    private static String toString(String[] packageNames) {
        if (packageNames == null) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer("[");
        for (String pn : packageNames) {
            buf.append(pn).append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Collection<String> values() {
        return this.map.values();
    }

    public Personalisation getPersonalisation() {
        if (this.p13n == null) {
            String p13nCompactString = this.map.get(KEY_P13N);
            log.info("p13n from " + p13nCompactString);
            assert (p13nCompactString != null);
            this.p13n = Personalisation.fromString(p13nCompactString);
        }
        return this.p13n;
    }

    public String toStorageString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            String key = e.getKey();
            XyAssert.xyAssert((key != null ? 1 : 0) != 0);
            assert (key != null);
            XyAssert.xyAssert((!key.equals("") ? 1 : 0) != 0);
            String value = e.getValue();
            if (value == null) {
                value = "";
            }
            value = value.replace("\n", "\\n");
            value = value.replace("\r", "\\r");
            sb.append(key + "=" + value + "\n");
        }
        return sb.toString();
    }

    public static PersonalisedMessageBundle fromStorageString(String s) {
        MiniStringReader msr = new MiniStringReader(s);
        Map<String, String> map = PersonalisedMessageBundle.toMap((MiniReader)msr, "localStorage");
        PersonalisedMessageBundle bundle = new PersonalisedMessageBundle();
        bundle.map = map;
        return bundle;
    }

    public static Map<String, String> toMap(MiniReader reader, String source) throws MiniIOException {
        HashMap<String, String> map = new HashMap<String, String>();
        MiniBufferedReader br = new MiniBufferedReader(reader);
        String line = br.readLine();
        int lineNo = 1;
        ParseContext parseContext = new ParseContext();
        while (line != null) {
            if ((line = line.trim()).startsWith("#+")) {
                parseContext.parseValue(line.substring(2));
            } else if (!line.startsWith("#") && !line.equals("")) {
                String value;
                int pos = line.indexOf(61);
                assert (pos > 0) : "parsing line " + lineNo + " in " + source + " failed. Found no '=' sign. Line = '" + line + "'";
                parseContext.flushTo(map, lineNo, source);
                parseContext.key = line.substring(0, pos);
                if (parseContext.key.equals("")) {
                    log.warn("Suspicious line nr. " + lineNo + ": " + line);
                }
                if (pos + 1 != line.length() && (value = line.substring(pos + 1, line.length())).trim().length() != 0) {
                    parseContext.parseValue(value.trim());
                }
            }
            ++lineNo;
            line = br.readLine();
        }
        parseContext.flushTo(map, lineNo, source);
        return map;
    }

    private static class ParseContext {
        String key;
        StringBuilder valueBuf;
        boolean addNewline;

        public ParseContext() {
            this.reset();
        }

        public void parseValue(String value) {
            boolean addNextNewline = true;
            String v = value;
            int i = v.indexOf("##");
            if (i >= 0) {
                addNextNewline = false;
                v = v.substring(0, i);
            }
            v = v.replace("\\n", "\n");
            if (this.addNewline) {
                this.valueBuf.append("\n");
            }
            this.valueBuf.append(v);
            this.addNewline = addNextNewline;
        }

        public void flushTo(Map<String, String> map, int lineNo, String source) {
            if (this.key != null) {
                String value = this.valueBuf.toString();
                if (map.containsKey(this.key)) {
                    throw new IllegalArgumentException("Key '" + this.key + "' was already defined. Just parsing " + source + ":" + lineNo);
                }
                map.put(this.key, value.length() == 0 ? null : value);
                log.trace("Mapping " + this.key + " = '" + value + "'");
                this.reset();
            }
        }

        private void reset() {
            this.key = null;
            this.valueBuf = new StringBuilder();
            this.addNewline = false;
        }
    }
}

