/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader;

import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.time.TimeProvider;
import org.joda.time.DateTimeZone;
import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;

public class ConfParamsResourceLoader
implements IConfigProvider {
    @ConfType(value=Personalisation.class)
    @ConfDoc(value="Personalisation (timezone,language)")
    public static final String P13N = "resource-p13n";
    @ConfType(value=boolean.class)
    @ConfDoc(value="If true, loads P13n resources only from classpath (not file system)")
    public static final String RUN_LOCAL = "resource-runLocal";

    private static final Personalisation createDefaultP13n() {
        DateTimeZone berlin = DateTimeZone.forID((String)"Europe/Berlin");
        long offsetMillis = berlin.getOffset(TimeProvider.getCurrentTimeInMillis());
        int offsetHours = (int)(offsetMillis / 3600000L);
        return new Personalisation(MiniLocale.De_DE, offsetHours);
    }

    public void configureDefaults(IConfig conf) {
        conf.setDefault(P13N, (Object)ConfParamsResourceLoader.createDefaultP13n(), true);
    }
}

