/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader.p13n;

import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.PersonalisedMessageBundle;
import de.xam.resourceloader.p13n.PersonalisedMessageBundleIO;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class P13nPropertyFileWriter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(P13nPropertyFileWriter.class);
    private final String[] supportedLanguages;
    private final String[] messagePagages;
    private final String[] prefixesToExclude;
    private final File targetDir;
    private final String lineEnd;
    private static final String FILENAME = "Msg";

    public P13nPropertyFileWriter(String[] supportedLanguages, String[] messagePagages, String[] prefixesToExclude, File targetDir, String lineEnd) {
        this.supportedLanguages = supportedLanguages;
        this.messagePagages = messagePagages;
        this.prefixesToExclude = prefixesToExclude;
        this.targetDir = targetDir;
        this.lineEnd = lineEnd;
    }

    public static void generate(String[] supportedLanguages, String[] messagePackages, String[] prefixesToExclude, File targetDir, String lineEnd) throws IOException {
        log.info("Generating for languages: " + Arrays.toString(supportedLanguages));
        log.info("Message packages: " + Arrays.toString(messagePackages));
        log.info("Excluded prefixes: " + Arrays.toString(prefixesToExclude));
        log.info("Target dir: " + targetDir.getAbsolutePath());
        TreeSet<String> allKeys = new TreeSet<String>();
        for (String localeStr : supportedLanguages) {
            log.trace("Generating for language '" + localeStr + "'");
            MiniLocale locale = MiniLocale.fromLocaleCode((String)localeStr);
            P13nPropertyFileWriter.generate(P13nPropertyFileWriter.getMessageBundleFromDefaultPackages(locale, messagePackages), prefixesToExclude, targetDir, allKeys, lineEnd);
        }
        StringWriter sw = new StringWriter();
        sw.write("# Generated by P13nPropertyFileWriter on " + new Date() + lineEnd);
        sw.write("# Size: " + allKeys.size() + " keys" + lineEnd);
        sw.write("# Testing Umlauts: 1-2-3 \u00e4-\u00f6-\u00fc" + lineEnd);
        for (String k : allKeys) {
            sw.write(k + "=" + lineEnd);
        }
        sw.close();
        String data = sw.getBuffer().toString();
        P13nPropertyFileWriter.writeFileWithTwoExtensions(targetDir, FILENAME, data);
        log.info("Done");
    }

    private static void generate(PersonalisedMessageBundle p13nBundle, String[] prefixesToExclude, File targetDir, Set<String> allKeys, String lineEnd) throws IOException {
        SortedMap<String, String> map = P13nPropertyFileWriter.toFilteredMap(p13nBundle, prefixesToExclude);
        allKeys.addAll(map.keySet());
        targetDir.mkdirs();
        String name = "Msg_" + p13nBundle.getPersonalisation().getLocale().toString();
        StringWriter sw = new StringWriter();
        sw.write("# Generated by P13nPropertyFileWriter on " + new Date() + lineEnd);
        sw.write("# Size: " + map.size() + " keys" + lineEnd);
        sw.write("# Testing Umlauts: 1-2-3 \u00e4-\u00f6-\u00fc" + lineEnd);
        for (String k : map.keySet()) {
            sw.write(k + "=" + (String)map.get(k) + lineEnd);
        }
        sw.write("hash=" + p13nBundle.getHash() + lineEnd);
        sw.close();
        String data = sw.getBuffer().toString();
        P13nPropertyFileWriter.writeFileWithTwoExtensions(targetDir, name, data);
    }

    public static PersonalisedMessageBundle getMessageBundleFromDefaultPackages(MiniLocale locale, String ... messagePackages) {
        Personalisation p13n = new Personalisation(locale, 0);
        boolean loadFromClasspathOnly = !Env.get().conf().getBoolean("resource-runLocal");
        PersonalisedMessageBundle p13nBundle = PersonalisedMessageBundleIO.instance(p13n, loadFromClasspathOnly, messagePackages);
        return p13nBundle;
    }

    private static SortedMap<String, String> toFilteredMap(PersonalisedMessageBundle p13nBundle, String ... prefixToExclude) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator it = p13nBundle.getRawKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!P13nPropertyFileWriter.isIncluded(key, prefixToExclude)) continue;
            String val = p13nBundle.get((Object)key);
            map.put(key, val);
        }
        log.info("Filtered map has " + map.size() + " entries");
        return map;
    }

    private static boolean isIncluded(String key, String[] prefixesToExclude) {
        for (String prefix : prefixesToExclude) {
            if (!key.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private static void writeFileWithTwoExtensions(File targetDir, String name, String data) throws IOException {
        FileUtils.writeStringToFile((File)new File(targetDir, name + ".properties"), (String)data, (String)"utf-8");
        FileUtils.writeStringToFile((File)new File(targetDir, name + ".utf8"), (String)data, (String)"utf-8");
    }

    @Override
    public void run() {
        try {
            P13nPropertyFileWriter.generate(this.supportedLanguages, this.messagePagages, this.prefixesToExclude, this.targetDir, this.lineEnd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

