/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader.p13n;

import com.google.common.cache.Cache;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.PersonalisedMessageBundle;
import de.xam.resourceloader.MavenResourceLoader;
import de.xam.resourceloader.ResourceLoaderTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.Stack;
import org.xydra.base.minio.MiniReader;
import org.xydra.base.minio.MiniStreamReader;
import org.xydra.common.NanoClock;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class PersonalisedMessageBundleIO {
    private static Logger log = LoggerFactory.getLogger(PersonalisedMessageBundleIO.class);
    public static final String DEFAULT_PACKAGE = "com.calpano.common.messages";

    public static Map<String, String> toMap(Reader reader, URL url) throws IOException {
        MiniStreamReader miniReader = new MiniStreamReader(reader);
        return PersonalisedMessageBundle.toMap((MiniReader)miniReader, (String)("" + url));
    }

    private static void internalize(PersonalisedMessageBundle pmb, URL url, String resourceName) {
        log.debug("Found resource: " + resourceName);
        if (url != null) {
            try {
                InputStream in = url.openStream();
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                pmb.putAll(PersonalisedMessageBundleIO.toMap(reader, url));
                ((Reader)reader).close();
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void crawlPackage(PersonalisedMessageBundle msg, ClassLoader cl, Personalisation p13n, String packageName, boolean loadFromClasspathOnly) {
        log.debug("START searching and loading p13n '" + p13n.toClassifier(3) + "' in package '" + packageName + "'");
        Stack fromGeneralToSpecific = PersonalisedMessageBundle.getFromGeneralToSpecific((String)packageName, (Personalisation)p13n);
        URL url = null;
        while (!fromGeneralToSpecific.empty()) {
            String resourceName = (String)fromGeneralToSpecific.pop();
            log.debug("Searching resources in " + resourceName);
            url = cl.getResource(resourceName);
            if (url == null && !loadFromClasspathOnly) {
                url = MavenResourceLoader.loadResource(resourceName, true, false);
            }
            if (url != null) {
                log.debug("Found:      " + resourceName);
                PersonalisedMessageBundleIO.internalize(msg, url, resourceName);
                continue;
            }
            log.trace("Not found: " + resourceName);
        }
    }

    private static void crawlPackage(PersonalisedMessageBundle msg, ResourceLoaderTool.Resolver resolver, Personalisation p13n, String packageName) {
        log.debug("START searching and loading p13n '" + p13n.toClassifier(3) + "' in package '" + packageName + "'");
        Stack fromGeneralToSpecific = PersonalisedMessageBundle.getFromGeneralToSpecific((String)packageName, (Personalisation)p13n);
        URL url = null;
        while (!fromGeneralToSpecific.empty()) {
            String resourceName = (String)fromGeneralToSpecific.pop();
            if (log.isTraceEnabled()) {
                log.trace("Searching resources in " + resourceName);
            }
            if ((url = resolver.resolveURL(resourceName)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found:      " + resourceName);
                }
                PersonalisedMessageBundleIO.internalize(msg, url, resourceName);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Not found: " + resourceName);
        }
    }

    public static PersonalisedMessageBundle instance(Personalisation p13n, boolean loadFromClasspathOnly, String ... packageNames) {
        if (p13n == null) {
            throw new IllegalArgumentException("Cannot load properties without personalisation. It is null");
        }
        NanoClock c = new NanoClock().start();
        log.debug("Creating PMB for " + p13n.toClassifier(3));
        PersonalisedMessageBundle msg = PersonalisedMessageBundleIO.cacheGet(p13n, packageNames);
        if (msg == null) {
            msg = new PersonalisedMessageBundle(p13n, packageNames);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            PersonalisedMessageBundleIO.crawlPackage(msg, cl, p13n, DEFAULT_PACKAGE, loadFromClasspathOnly);
            if (packageNames != null) {
                for (String packageName : packageNames) {
                    if (packageName == null) continue;
                    PersonalisedMessageBundleIO.crawlPackage(msg, cl, p13n, packageName, loadFromClasspathOnly);
                }
            }
            msg.put("_version", msg.getHash());
            c.stopAndStart("added-version-hash");
            PersonalisedMessageBundleIO.cachePut(p13n, packageNames, msg);
            c.stopAndStart("computed-pmb");
            log.info("Created PMB for p13n '" + p13n.toCompactString() + "' with " + msg.size() + " entries, _version=" + msg.getHash());
        }
        return msg;
    }

    public static PersonalisedMessageBundle instance(Personalisation p13n, ResourceLoaderTool.Resolver resolver, String ... packageNames) {
        if (p13n == null) {
            throw new IllegalArgumentException("Cannot load properties without personalisation. It is null");
        }
        NanoClock c = new NanoClock().start();
        log.debug("Creating PMB for " + p13n.toClassifier(3));
        PersonalisedMessageBundle msg = PersonalisedMessageBundleIO.cacheGet(p13n, packageNames);
        if (msg == null) {
            msg = new PersonalisedMessageBundle(p13n, packageNames);
            PersonalisedMessageBundleIO.crawlPackage(msg, resolver, p13n, DEFAULT_PACKAGE);
            if (packageNames != null) {
                for (String packageName : packageNames) {
                    if (packageName == null) continue;
                    PersonalisedMessageBundleIO.crawlPackage(msg, resolver, p13n, packageName);
                }
            }
            log.debug("Created PMB for p13n '" + p13n.toCompactString() + "' with " + msg.size() + " entries");
            PersonalisedMessageBundleIO.cachePut(p13n, packageNames, msg);
            c.stopAndStart("computed-pmb");
        }
        msg.put("_version", msg.getHash());
        c.stopAndStart("added-version-hash");
        log.info("Created PMB for p13n '" + p13n.toCompactString() + "' with " + msg.size() + " entries, _version=" + msg.getHash());
        return msg;
    }

    public static PersonalisedMessageBundle instance(Personalisation p13n, String ... packageNames) {
        return PersonalisedMessageBundleIO.instance(p13n, true, packageNames);
    }

    private static void cachePut(Personalisation p13n, String[] packageNames, PersonalisedMessageBundle bundle) {
        String key = PersonalisedMessageBundleIO.toCacheKey(p13n, packageNames);
        Cache instanceCache = (Cache)Env.get().conf().tryToResolve("p13n-instanceCache");
        if (instanceCache != null) {
            instanceCache.put((Object)key, (Object)bundle);
        }
    }

    private static PersonalisedMessageBundle cacheGet(Personalisation p13n, String[] packageNames) {
        String key = PersonalisedMessageBundleIO.toCacheKey(p13n, packageNames);
        if (!Env.get().conf().getBoolean("p13n-cacheBundles")) {
            log.debug("No PersonalisedMessageBundle caching, hepls debugging");
            return null;
        }
        Cache instanceCache = (Cache)Env.get().conf().tryToResolve("p13n-instanceCache");
        if (instanceCache != null) {
            return (PersonalisedMessageBundle)instanceCache.getIfPresent((Object)key);
        }
        return null;
    }

    private static String toCacheKey(Personalisation p13n, String[] packageNames) {
        StringBuilder sb = new StringBuilder();
        sb.append(p13n.toCompactString());
        if (packageNames != null) {
            for (String packageName : packageNames) {
                sb.append(packageName);
            }
        }
        return sb.toString();
    }
}

