/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.store;

import de.xam.datafiles.store.AbstractDataMapStore;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.util.DataFiles;
import java.util.Collection;
import java.util.HashSet;
import org.xydra.conf.IConfig;

public class ConfDataMapStore
extends AbstractDataMapStore
implements IDataMapStore {
    private final IConfig conf;

    public ConfDataMapStore(IConfig conf) {
        this.conf = conf;
    }

    @Override
    public Collection<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Object o : this.conf.getDefinedKeys()) {
            keys.add((String)o);
        }
        return keys;
    }

    @Override
    public Object getValue(String key) {
        return this.conf.tryToGet(key);
    }

    @Override
    public void setValue(String key, Object value) {
        assert (value == null || DataFiles.hasKnownType(value)) : "Type of '" + value + "' is " + (Object)((Object)DataFiles.getValueType(value));
        this.conf.set(key, value);
    }
}

