/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.util;

import de.xam.datafiles.datamap.IDataMap;
import de.xam.datafiles.datamap.MemoryDataMap;
import de.xam.datafiles.handler.IDataFileHandler;
import de.xam.datafiles.store.DataMapStoreTools;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.util.StringCodec;
import de.xam.files.FileTools;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.conf.IConfig;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DataFiles {
    private static final Logger log = LoggerFactory.getLogger(DataFiles.class);

    public static void addAll(IConfig srcConf, IDataMap targetDataMap) {
        for (String key : srcConf.getExplicitlyDefinedKeys()) {
            Object value = srcConf.get(key);
            DataFiles.setValue(targetDataMap, key, value);
        }
    }

    public static FileFilter combineFilters(final FileFilter optionalRestrictingFileFilter, final IDataFileHandler[] handlers) {
        assert (handlers != null);
        assert (handlers.length > 0);
        FileFilter combinedFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (optionalRestrictingFileFilter != null && !optionalRestrictingFileFilter.accept(pathname)) {
                    log.trace("Rejected by optional restricting file filter: " + pathname);
                    return false;
                }
                for (IDataFileHandler h : handlers) {
                    if (!h.getFileFilter().accept(pathname)) continue;
                    log.trace("Found handler for " + pathname + ": " + h.getExtension());
                    return true;
                }
                return false;
            }
        };
        return combinedFileFilter;
    }

    private static FileTools.IFileProcessor combineProcessors(final IDataMap dataMap, final IDataFileHandler ... handlers) {
        FileTools.IFileProcessor combinedProcessor = new FileTools.IFileProcessor(){

            public void process(File f) throws IOException {
                for (IDataFileHandler h : handlers) {
                    if (!h.getFileFilter().accept(f)) continue;
                    IDataMapStore localMap = h.read(f);
                    log.debug("Read data from " + f.getAbsolutePath() + " => " + localMap.getKeys().size() + " keys");
                    DataMapStoreTools.merge(dataMap, localMap);
                }
            }
        };
        return combinedProcessor;
    }

    public static IDataMap createDataMap() {
        return new MemoryDataMap();
    }

    private static Object getValueObject(IDataMap dataMap, String key) {
        IDataMap.Type type = dataMap.getType(key);
        if (type == null) {
            return null;
        }
        switch (type) {
            case Boolean: {
                return dataMap.getBoolean(key);
            }
            case Long: {
                return dataMap.getLong(key);
            }
            case String: {
                return dataMap.getString(key);
            }
            case StringSet: {
                return dataMap.getStringSet(key);
            }
            case StringList: {
                return dataMap.getStringList(key);
            }
            case StringMap: {
                return dataMap.getStringMap(key);
            }
        }
        throw new AssertionError();
    }

    public static boolean hasKnownType(Object value) {
        IDataMap.Type type = DataFiles.getValueType(value);
        return type != null;
    }

    public static IDataMap readFileIntoDataMap(File file, IDataFileHandler ... handlers) throws IOException {
        assert (file != null);
        IDataMap dataMap = DataFiles.createDataMap();
        if (handlers == null || handlers.length == 0) {
            return dataMap;
        }
        FileTools.IFileProcessor combinedProcessor = DataFiles.combineProcessors(dataMap, handlers);
        combinedProcessor.process(file);
        return dataMap;
    }

    public static IDataMap readFilesAndMergeIntoDataMap(IDataMap initialDataMap, File rootDir, FileFilter fileFilter, boolean followSymbolicLinks, IDataFileHandler ... handlers) throws IOException {
        assert (rootDir != null);
        MemoryDataMap dataMap = new MemoryDataMap();
        DataMapStoreTools.copy(initialDataMap.getStore(), dataMap.getStore());
        if (handlers == null || handlers.length == 0) {
            return dataMap;
        }
        FileFilter combinedFileFilter = DataFiles.combineFilters(fileFilter, handlers);
        FileTools.IFileProcessor combinedProcessor = DataFiles.combineProcessors(dataMap, handlers);
        FileTools.process((File)rootDir, (FileFilter)combinedFileFilter, (FileTools.IFileProcessor)combinedProcessor, null, (boolean)followSymbolicLinks);
        return dataMap;
    }

    public static IDataMap readFilesAndMergeIntoDataMap(IDataMap initialDataMap, File[] rootDirs, FileFilter fileFilter, IDataFileHandler ... handlers) throws IOException {
        assert (rootDirs != null);
        MemoryDataMap dataMap = new MemoryDataMap();
        DataMapStoreTools.copy(initialDataMap.getStore(), dataMap.getStore());
        if (handlers == null || handlers.length == 0) {
            return dataMap;
        }
        FileFilter combinedFileFilter = DataFiles.combineFilters(fileFilter, handlers);
        FileTools.IFileProcessor combinedProcessor = DataFiles.combineProcessors(dataMap, handlers);
        FileTools.process((File[])rootDirs, (FileFilter)combinedFileFilter, (FileTools.IFileProcessor)combinedProcessor);
        return dataMap;
    }

    private static void setValue(IDataMap dataMap, String key, Object value) {
        assert (value != null);
        IDataMap.Type type = DataFiles.getValueType(value);
        assert (type != null);
        switch (type) {
            case Boolean: {
                dataMap.setBoolean(key, (Boolean)value);
                break;
            }
            case Long: {
                dataMap.setLong(key, (Long)value);
                break;
            }
            case String: {
                dataMap.setString(key, (String)value);
                break;
            }
            case StringSet: {
                dataMap.setStringSet(key, (Set)value);
                break;
            }
            case StringList: {
                dataMap.setStringList(key, (List)value);
                break;
            }
            case StringMap: {
                dataMap.setStringMap(key, (Map)value);
            }
        }
    }

    public static Map<String, Object> toMap(IDataMap dataMap) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : dataMap.getKeys()) {
            map.put(key, DataFiles.getValueObject(dataMap, key));
        }
        return map;
    }

    public static StringBuilder valueObjectToString(Object value) {
        return StringCodec.toValueStringFromObject(value);
    }

    public static Object valueStringToObject(String valueString) {
        return StringCodec.toObjectFromValueString(valueString);
    }

    public static IDataMap.Type getValueType(Object o) throws IllegalArgumentException {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return IDataMap.Type.Boolean;
        }
        if (o instanceof Long) {
            return IDataMap.Type.Long;
        }
        if (o instanceof String) {
            return IDataMap.Type.String;
        }
        if (o instanceof Set) {
            return IDataMap.Type.StringSet;
        }
        if (o instanceof List) {
            return IDataMap.Type.StringList;
        }
        if (o instanceof Map) {
            return IDataMap.Type.StringMap;
        }
        throw new IllegalArgumentException("unhandled type '" + o.getClass().getCanonicalName() + "'");
    }
}

