/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.IFileFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class FileFormats {
    private static Collection<FileFormat> registeredFileFormats = new HashSet<FileFormat>();
    public static final FileFormat KGIF_1_1_0 = new FileFormat("kgif1_1_0", "Knowledge Graph Interchange Format (KGIF) 1.1.0", "XML", "items.kgif.xml", new String[]{"kgif.xml"}, "application/kgif+xml", 1.0, "Specification at http://bit.ly/kgif-spec");
    public static final FileFormat KGIF_1_0_0 = new FileFormat("kgif1_0_0", "Knowledge Graph Interchange Format (KGIF) 1.0.0 (Outdated)", "XML", "items.kgif.xml", new String[]{"kgif.xml"}, "application/kgif+xml", 0.1, "Specification: See current KGIF Format");
    public static final FileFormat KGIF_1_0_1 = new FileFormat("kgif1_0_1", "Knowledge Graph Interchange Format (KGIF) 1.0.1 (Outdated)", "XML", "items.kgif.xml", new String[]{"kgif.xml"}, "application/kgif+xml", 0.101, "Specification: See current KGIF Format");

    public static Collection<FileFormat> getRegisteredFileFormats() {
        return Collections.unmodifiableCollection(registeredFileFormats);
    }

    public static void register(FileFormat ff) {
        if (ff == null) {
            throw new IllegalArgumentException("No nulls here");
        }
        registeredFileFormats.add(ff);
    }

    public static FileFormat getFormatByName(String formatName) {
        for (FileFormat ff : FileFormats.getRegisteredFileFormats()) {
            assert (ff != null);
            assert (ff.getFormatName() != null);
            if (!ff.getFormatName().equals(formatName)) continue;
            return ff;
        }
        return null;
    }

    public static boolean matchesExtension(IFileFormat fileFormat, String name) {
        assert (name != null);
        int i$ = 0;
        String[] arr$ = fileFormat.getExtensions();
        int len$ = arr$.length;
        if (i$ < len$) {
            String ext = arr$[i$];
            return name.endsWith("." + ext);
        }
        return false;
    }

    public static boolean matchesDefaultFileName(FileFormat fileFormat, String name) {
        assert (name != null);
        return fileFormat.getDefaultFileName() != null && fileFormat.getDefaultFileName().equals(name);
    }

    static {
        FileFormats.register(KGIF_1_0_0);
        FileFormats.register(KGIF_1_0_1);
        FileFormats.register(KGIF_1_1_0);
    }
}

