/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_0.ioutils;

import com.calpano.kgif.v1_0_0.gen.Attribute;
import com.calpano.kgif.v1_0_0.gen.Content;
import com.calpano.kgif.v1_0_0.gen.Graph;
import com.calpano.kgif.v1_0_0.gen.Kgif;
import com.calpano.kgif.v1_0_0.gen.Link;
import com.calpano.kgif.v1_0_0.gen.Metadata;
import com.calpano.kgif.v1_0_0.gen.Node;
import java.util.List;

public class KgifDump {
    public static void dump(Kgif kgif) {
        System.out.println(kgif.getHeader().getSchemaVersionNumber());
        System.out.println(kgif.getHeader().getSchemaVersionDate());
        Graph graph = kgif.getGraph();
        List<Object> list = graph.getNodeOrLink();
        for (Object o : list) {
            if (o instanceof Node) {
                KgifDump.dump((Node)o);
            }
            if (!(o instanceof Link)) continue;
            KgifDump.dump((Link)o);
        }
    }

    private static void dump(Link link) {
        System.out.println("LINK [" + link.getId() + "] " + link.getFrom() + "--(" + link.getType() + ")-->" + link.getTo());
        KgifDump.dump(link.getMetadata());
    }

    static void dump(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        if (metadata.getAttribute() == null) {
            return;
        }
        for (Attribute att : metadata.getAttribute()) {
            System.out.println(att.getName() + " = " + att.getvalue());
        }
    }

    private static void dump(Node node) {
        System.out.println("NODE [" + node.getId() + "] '" + node.getLabel().getvalue() + "'");
        KgifDump.dump(node.getMetadata());
        Content content = node.getContent();
        if (content != null) {
            System.out.println("CONTENT " + content.getContentType());
            System.out.println("'" + content.getvalue() + "'");
        }
    }

    public static void dump(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            KgifDump.dump(node);
        } else if (o instanceof Link) {
            Link link = (Link)o;
            KgifDump.dump(link);
        } else {
            System.out.println(o.toString());
        }
    }
}

