/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource.impl.jspwiki;

import com.google.web.bindery.event.shared.EventBus;
import de.xam.cmodel.service.ServiceState;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.jspwiki.HomewikiSource;
import de.xam.kfacet.impl.wiki.VocabularyFacetWiki;
import de.xam.kfacet.impl.wiki.WikiConfig;
import de.xam.kfacet.impl.wiki.spi.IEntity2Href;
import de.xam.ksource.ISource;
import de.xam.ksource.ISourceItem;
import de.xam.ksource.KSources;
import de.xam.ksource.VocabularySources;
import de.xam.ksource.impl.jspwiki.JspWikiSourceItem;
import de.xam.ksource.impl.jspwiki.VocabularySourceJspWiki;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IContentService;
import de.xam.mybase.model.api.IMyBase;
import de.xam.vocabulary.Vocabulary;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.common.NanoClock;
import org.xydra.conf.IConfig;
import org.xydra.env.Env;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class JspWikiSource
implements ISource {
    private static final Logger log = LoggerFactory.getLogger(JspWikiSource.class);
    public static final String PREFIX = "jspwiki";
    private static final boolean PARALLEL_MODE = false;
    HomewikiSource homewikiSource;
    IItemSet itemSet;
    private Thread indexThread;
    IMyBase myBase;
    IEntity2Href entity2Href;
    private ServiceState serviceState = ServiceState.initial();

    public JspWikiSource(IMyBase myBase, IEntity2Href entity2Href) {
        this.myBase = myBase;
        this.entity2Href = entity2Href;
        IConfig conf = Env.get().conf();
        String rootDir = conf.getString("homewikiSync-textDir");
        String encoding = conf.getString("homewikiSync-sourceEncoding");
        this.homewikiSource = new HomewikiSource(new File(rootDir), encoding);
    }

    public boolean canWrite() {
        return true;
    }

    protected JspWikiSourceItem getPageByNameFromJspWiki(String pageName) {
        assert (this.homewikiSource.getPageNameSetLowerCased().contains(pageName.toLowerCase())) : "" + pageName.toLowerCase();
        return new JspWikiSourceItem(this, pageName);
    }

    public String getPrefix() {
        return VocabularySourceJspWiki._VOC.getNamespace();
    }

    protected JspWikiSourceItem getSourceItemById(XId itemId) {
        IItem item = this.itemSet.getItemById(itemId);
        JspWikiSourceItem jwsi = new JspWikiSourceItem(this, item.getDisplayString());
        return jwsi;
    }

    public void indexPageWithName(String pageName, IItemSet itemSet) throws IOException {
        this.getPageByNameFromJspWiki(pageName).readDataToMyBase(itemSet);
    }

    public void enableWriteBackMode(IItemSet itemSet, EventBus eventBus) {
    }

    public void init(IItemSet itemSet) {
        this.itemSet = itemSet;
        NanoClock clock = new NanoClock();
        clock.start();
        this.homewikiSource.indexFiles();
        clock.stopAndStart("index-files");
        log.info("Stats = " + clock.getStats());
    }

    public Iterator<ISourceItem> iterator() {
        Iterator it = this.homewikiSource.pageNamesCaseSensitiveIterator();
        return Iterators.transform((Iterator)it, (ITransformer)new ITransformer<String, ISourceItem>(){

            public JspWikiSourceItem transform(String pageName) {
                return JspWikiSource.this.getPageByNameFromJspWiki(pageName);
            }
        });
    }

    public void refresh_sync(IItemSet itemSet) throws IOException {
        String stats;
        JspWikiSourceItem jsi;
        ISourceItem si;
        NanoClock clock = new NanoClock();
        clock.start();
        XId sourceId = KSources.getSourceId((ISource)this);
        IItem sourceItem = itemSet.getItemById(sourceId);
        assert (sourceItem != null);
        clock.stopAndStart("add-metadata");
        log.info("===== pre-indexing");
        Iterator<ISourceItem> it = this.iterator();
        int count = 0;
        while (it.hasNext() && this.getServiceState().shouldRun()) {
            si = it.next();
            jsi = (JspWikiSourceItem)si;
            jsi.readDataAndParse(true, false);
            if (++count % 100 != 0 && it.hasNext()) continue;
            stats = "Pre-Indexed " + count + " items; last was '" + si.getLocalStringId() + "'";
            sourceItem.setAttribute(VocabularySources.ATTRIBUTE_SOURCE_INDEX_STATS, (XValue)XV.toValue((String)stats));
        }
        clock.stopAndStart("preindex-all-sourceitems");
        log.info("===== full-indexing");
        it = this.iterator();
        count = 0;
        while (it.hasNext() && this.getServiceState().shouldRun()) {
            si = it.next();
            jsi = (JspWikiSourceItem)si;
            jsi.parseAgain();
            if (++count % 50 != 0 && it.hasNext()) continue;
            stats = "Full-Indexed " + count + " items; last was '" + si.getLocalStringId() + "'";
            sourceItem.setAttribute(VocabularySources.ATTRIBUTE_SOURCE_INDEX_STATS, (XValue)XV.toValue((String)stats));
        }
        clock.stopAndStart("index-all-sourceitems");
        log.info("done re-indexing source '" + this.getPrefix() + "'; stats=" + clock.getStats());
        if (this.serviceState.shouldStop()) {
            this.serviceState = this.serviceState.goTo(ServiceState.stopped);
        }
    }

    public Map<XId, String> shouldPersistInExternalFile() {
        HashMap<XId, String> map = new HashMap<XId, String>();
        map.put(VocabularyFacetWiki.ATTRIBUTE_WIKITEXT, "txt");
        return map;
    }

    public int size() {
        return this.homewikiSource.countPages();
    }

    public void stop() {
        this.serviceState = this.indexThread != null && this.indexThread.isAlive() ? this.serviceState.goTo(ServiceState.stopping) : this.serviceState.goTo(ServiceState.stopped);
    }

    public void start() {
        if (!this.getServiceState().mayStart()) {
            throw new IllegalStateException();
        }
        this.serviceState = this.serviceState.goTo(ServiceState.running);
        this.indexThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JspWikiSource.this.refreshBuiltInPages(WikiConfig.builtInPagesList, JspWikiSource.this.itemSet);
                    JspWikiSource.this.refresh_sync(JspWikiSource.this.itemSet);
                }
                catch (IOException e) {
                    log.warn("I/O exception in source " + JspWikiSource.this.getPrefix(), (Throwable)e);
                    System.exit(-1);
                }
            }
        }, this.getPrefix() + "-refresh");
        this.indexThread.setPriority(2);
        this.indexThread.start();
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void refreshBuiltInPages(Iterable<String> pageNames, IItemSet pageNam) throws IOException {
        for (String pageName : pageNames) {
            this.indexPageWithName(pageName, pageNam);
        }
    }

    public void addBuiltIns(IItemSet itemSet) {
        MyBases.addMetadata((IItemSet)itemSet, (IContentService)this);
    }

    public Vocabulary getVocabulary() {
        return VocabularySourceJspWiki._VOC;
    }

    public String getLabel() {
        return "JspWiki";
    }

    public XId getId() {
        return KSources.getSourceId((ISource)this);
    }
}

