/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.impl;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Query;
import com.sonicmetrics.core.shared.ISonicDB;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicQueryResult;
import com.sonicmetrics.core.shared.query.ISonicListener;
import com.sonicmetrics.core.shared.query.ISonicQuery;
import com.sonicmetrics.core.shared.query.ISonicQueryResult;
import com.sonicmetrics.core.shared.query.SonicMetadataResult;
import com.sonicmetrics.core.shared.query.SonicQuery;
import com.sonicmetrics.core.shared.query.TimeConstraint;
import com.sonicmetrics.core.shared.util.SharedIndexedDay;
import com.sonicmetrics.gaeserver.impl.GaeUtils;
import com.sonicmetrics.gaeserver.impl.SonicEventCodec;
import com.sonicmetrics.gaeserver.impl.SonicStoringListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.index.iterator.NoneIterator;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.XGae;

public class GaeSonicDB
implements ISonicDB {
    public static final GaeSonicDB INSTANCE = new GaeSonicDB();
    private static final Logger log = LoggerFactory.getLogger(GaeSonicDB.class);
    private static final String[] SEARCH_PROPERTIES = new String[]{"!sub", "!cat", "!act", "!lab", "!src"};
    private final SonicStoringListener store;
    private final Set<ISonicListener> listeners = new HashSet<ISonicListener>();
    private static long BIGBANG = 1293840000000L;

    private static void addResultsForSearch(SonicMetadataResult smr, String propKeySubject, String keywordPrefix) {
        Iterator<Entity> it = GaeUtils.searchProperty("SEV", propKeySubject, propKeySubject, GaeSonicDB.toLimit(500), new String[0]);
        while (it.hasNext()) {
            Entity entity = it.next();
            SonicEventCodec.addToSonicMetadataResult(entity, smr);
        }
    }

    private static int toLimit(int limit) {
        return Math.max(10000, limit);
    }

    private GaeSonicDB() {
        this.store = new SonicStoringListener();
    }

    public void delete(ISonicQuery sonicQuery) {
        Query query = SonicEventCodec.toGaeQuery(sonicQuery);
        log.info("Deleting all events matching  " + query);
        GaeUtils.deleteMatchingEntities(query, GaeSonicDB.toLimit(sonicQuery.getLimit()));
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public ISonicQueryResult query(ISonicQuery sonicQuery) {
        log.debug("return directly from datastore " + sonicQuery.getTimeConstraint());
        return this.queryDatastore(sonicQuery);
    }

    @Deprecated
    public static List<TimeInterval> toCachableTimeIntervals(TimeInterval ti) {
        long millisOnLastMinute;
        long millisOnLastDay;
        long minutesOnLastDay;
        ArrayList<TimeInterval> intervals = new ArrayList<TimeInterval>();
        int startDay = SharedIndexedDay.toIndexedDay((long)ti.start, (long)BIGBANG);
        int endDay = SharedIndexedDay.toIndexedDay((long)ti.end, (long)BIGBANG);
        long endUtc = SharedIndexedDay.toUtc((int)endDay, (long)BIGBANG);
        int days = endDay - startDay;
        if (days > 0) {
            intervals.add(new TimeInterval(SharedIndexedDay.toUtc((int)startDay, (long)BIGBANG), endUtc));
        }
        if ((minutesOnLastDay = (millisOnLastDay = SharedIndexedDay.toTimeOnIndexedDay((long)ti.end, (long)BIGBANG)) / 60000L) > 0L) {
            intervals.add(new TimeInterval(endUtc, endUtc + minutesOnLastDay * 60000L));
        }
        long secondsStart = endUtc + minutesOnLastDay * 60000L;
        long TEN_SECONDS = 10000L;
        for (long remainingMillis = millisOnLastMinute = millisOnLastDay - minutesOnLastDay * 60000L; remainingMillis > 10000L; remainingMillis -= 10000L) {
            intervals.add(new TimeInterval(secondsStart, secondsStart + 10000L));
            secondsStart += 10000L;
        }
        intervals.add(new TimeInterval(secondsStart, ti.end));
        return intervals;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(GaeSonicDB.toCachableTimeIntervals(new TimeInterval(BIGBANG, BIGBANG + 100000000005L)).toArray()));
    }

    public ISonicQueryResult queryDatastore(ISonicQuery sonicQuery) {
        Query query = SonicEventCodec.toGaeQuery(sonicQuery);
        log.debug("Executiong query: " + query);
        Iterator<Entity> it = GaeUtils.toIterator(query, sonicQuery.getLimit());
        Iterator<ISonicEvent> eventIterator = SonicEventCodec.convert(it, sonicQuery.getLimit());
        SonicQueryResult sqr = new SonicQueryResult(eventIterator);
        return sqr;
    }

    public ISonicEvent queryForSingleEventByKey(String key) {
        Query query = SonicEventCodec.toGaeQueryForSingleEventByKey(key);
        Iterator<Entity> it = GaeUtils.toIterator(query, 2);
        Iterator<ISonicEvent> eventIterator = SonicEventCodec.convert(it, 2L);
        return eventIterator.next();
    }

    public void deleteSingleEventByKey(String key) {
        Query query = SonicEventCodec.toGaeQueryForSingleEventByKey(key);
        GaeUtils.deleteMatchingEntities(query, 2);
    }

    public void receiveEvent(ISonicEvent sonicEvent) {
        this.store.receiveEvent(sonicEvent);
        this.notifyAboutEvent(sonicEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAboutEvent(ISonicEvent sonicEvent) {
        Set<ISonicListener> set = this.listeners;
        synchronized (set) {
            for (ISonicListener l : this.listeners) {
                l.receiveEvent(sonicEvent);
            }
        }
    }

    public void receiveEventAsync(ISonicEvent sonicEvent) {
        this.store.receiveEventAsync(sonicEvent);
        this.notifyAboutEvent(sonicEvent);
    }

    public void receiveEventsAsync(Iterable<? extends ISonicEvent> it) {
        this.store.receiveEventsAsync(it);
        for (ISonicEvent iSonicEvent : it) {
            this.notifyAboutEvent(iSonicEvent);
        }
    }

    public void receiveEvents(Iterable<? extends ISonicEvent> it) {
        this.store.receiveEvents(it);
        for (ISonicEvent iSonicEvent : it) {
            this.notifyAboutEvent(iSonicEvent);
        }
    }

    public SonicMetadataResult search(String keywordPrefix) {
        SonicMetadataResult smr = new SonicMetadataResult();
        for (String propertyName : SEARCH_PROPERTIES) {
            GaeSonicDB.addResultsForSearch(smr, propertyName, keywordPrefix);
        }
        return smr;
    }

    public void setKey(ISonicEvent sonicEvent) {
        String key = SonicEventCodec.generateKeyName(sonicEvent.getWhen());
        sonicEvent.setKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ISonicListener sonicListener) {
        Set<ISonicListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(sonicListener);
        }
    }

    public void deleteAllData() {
        this.delete((ISonicQuery)SonicQuery.build((TimeConstraint)TimeConstraint.ALL_UNTIL_NOW).done());
    }

    @Deprecated
    public static class CachedResult
    implements ISonicQueryResult {
        private NoneIterator<ISonicEvent> base;

        public CachedResult(TimeConstraint tc) {
            int firstDay = SharedIndexedDay.toIndexedDay((long)tc.start, (long)BIGBANG);
            int lastDay = SharedIndexedDay.toIndexedDay((long)tc.end, (long)BIGBANG) - 1;
            if (lastDay - firstDay <= 0) {
                this.base = NoneIterator.create();
            } else {
                String key = "d" + firstDay + "x" + lastDay;
                Object result = XGae.get().memcache().get((Object)key);
            }
        }

        public Iterator<ISonicEvent> iterator() {
            return null;
        }
    }

    public static class TimeInterval
    implements Serializable {
        private static final long serialVersionUID = 4422692439514081638L;
        long start;
        long end;

        public TimeInterval(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String toCacheKey() {
            return "TI" + this.start + "-" + this.end;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + ")";
        }

        public void includeTime(long utc) {
            if (utc < this.start) {
                this.start = utc;
            } else if (utc - 1L > this.end) {
                this.end = utc - 1L;
            }
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setStartAndEnd(long utc) {
            this.start = utc;
            this.end = utc;
        }

        public boolean contains(long utc) {
            return this.start <= utc && utc <= this.end;
        }

        public long getLength() {
            return this.end - this.start;
        }
    }
}

