/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.impl;

import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.PropertyProjection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Text;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.iterator.TransformingIterator;

public class GaeUtils {
    public static final String KEY = "__key__";
    public static final String LAST_UNICODE_CHAR = "\uffff";
    private static final Set<String> PYTHON_RESERVED_KEYS = new HashSet<String>();

    static Query.FilterPredicate toFilter(String key, String value) {
        return new Query.FilterPredicate(key, Query.FilterOperator.EQUAL, (Object)value);
    }

    public static void setPrefixRangeFilter(Query query, String propName, String kind, String valuePrefix) {
        Query.CompositeFilter filter = Query.CompositeFilterOperator.and((Query.Filter[])new Query.Filter[]{new Query.FilterPredicate(propName, Query.FilterOperator.GREATER_THAN, (Object)KeyFactory.createKey((String)kind, (String)("" + valuePrefix))), new Query.FilterPredicate(propName, Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)KeyFactory.createKey((String)kind, (String)("" + valuePrefix + LAST_UNICODE_CHAR)))});
        query.setFilter((Query.Filter)filter);
    }

    public static void addProjections(Query query, String ... propertyNames) {
        if (propertyNames == null) {
            return;
        }
        for (String propName : propertyNames) {
            query.addProjection((Projection)new PropertyProjection(propName, String.class));
        }
    }

    public static String fromGaePropertyValue(Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof Text) {
            return ((Text)propertyValue).getValue();
        }
        return propertyValue.toString();
    }

    public static boolean isReservedPropertyName(String name) {
        return name.startsWith("_") || PYTHON_RESERVED_KEYS.contains(name);
    }

    public static Iterator<Entity> searchProperty(String kind, String searchProperty, String searchPrefix, int limit, String ... projectedProperties) {
        Query query = new Query(kind);
        GaeUtils.setPrefixRangeFilter(query, searchProperty, kind, searchPrefix);
        GaeUtils.addProjections(query, projectedProperties);
        return GaeUtils.toIterator(query, limit);
    }

    public static Iterator<Entity> toIterator(Query query, int limit) {
        PreparedQuery prepQuery = GaeUtils.toExecutableQuery(query);
        Iterator<Entity> it = prepQuery.asIterable(FetchOptions.Builder.withLimit((int)limit)).iterator();
        return it;
    }

    static PreparedQuery toExecutableQuery(Query query) {
        return DatastoreServiceFactory.getDatastoreService().prepare(query);
    }

    public static Object toPropertyValue(String s) {
        if (s.length() > 400) {
            Text value = new Text(s);
            return value;
        }
        return s;
    }

    static Query setFilter(Query query, Map<String, String> filter) {
        ArrayList<Query.FilterPredicate> subFilters = new ArrayList<Query.FilterPredicate>();
        Query.CompositeFilterOperator.and(subFilters);
        if (filter != null) {
            for (Map.Entry<String, String> p : filter.entrySet()) {
                if (p == null) continue;
                if (p.getKey() == null) {
                    throw new IllegalArgumentException("A filterKey was null");
                }
                if (p.getKey().equals("")) {
                    throw new IllegalArgumentException("A filterValue was the empty string");
                }
                if (p.getValue() == null || p.getValue().equals("")) continue;
                String key = p.getKey().trim();
                String value = p.getValue().trim();
                subFilters.add(GaeUtils.toFilter(key, value));
            }
        }
        return query;
    }

    public static void deleteMatchingEntities(Query query, int limit) {
        query.setKeysOnly();
        PreparedQuery prepQuery = GaeUtils.toExecutableQuery(query);
        Iterator it = prepQuery.asIterable(FetchOptions.Builder.withLimit((int)limit)).iterator();
        TransformingIterator keyIt = new TransformingIterator(it, (ITransformer)new ITransformer<Entity, Key>(){

            public Key transform(Entity in) {
                return in.getKey();
            }
        });
        LinkedList keys = new LinkedList();
        Iterators.addAll((Iterator)keyIt, keys);
        DatastoreServiceFactory.getDatastoreService().delete(keys);
    }

    static {
        PYTHON_RESERVED_KEYS.add("all");
        PYTHON_RESERVED_KEYS.add("app");
        PYTHON_RESERVED_KEYS.add("copy");
        PYTHON_RESERVED_KEYS.add("delete");
        PYTHON_RESERVED_KEYS.add("entity");
        PYTHON_RESERVED_KEYS.add("entity_type");
        PYTHON_RESERVED_KEYS.add("fields");
        PYTHON_RESERVED_KEYS.add("from_entity");
        PYTHON_RESERVED_KEYS.add("get");
        PYTHON_RESERVED_KEYS.add("gql");
        PYTHON_RESERVED_KEYS.add("instance_properties");
        PYTHON_RESERVED_KEYS.add("is_saved");
        PYTHON_RESERVED_KEYS.add("key");
        PYTHON_RESERVED_KEYS.add("key_name");
        PYTHON_RESERVED_KEYS.add("kind");
        PYTHON_RESERVED_KEYS.add("parent");
        PYTHON_RESERVED_KEYS.add("parent_key");
        PYTHON_RESERVED_KEYS.add("properties");
        PYTHON_RESERVED_KEYS.add("put");
        PYTHON_RESERVED_KEYS.add("setdefault");
        PYTHON_RESERVED_KEYS.add("to_xml");
        PYTHON_RESERVED_KEYS.add("update");
    }
}

