/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.rest;

import com.sonicmetrics.core.shared.query.SonicMetadataResult;
import com.sonicmetrics.gaeserver.impl.GaeSonicDB;
import com.sonicmetrics.gaeserver.rest.SonicResource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.ServletUtils;

public class MetadataResource
extends SonicResource {
    private static final String KEYWORD = "q";
    private static final Logger log = LoggerFactory.getLogger(MetadataResource.class);

    public static void restless(Restless restless, boolean allowAll) {
        RestlessParameter[] searchParams = new RestlessParameter[]{new RestlessParameter(KEYWORD, "sonicmetrics"), new RestlessParameter("callback", null)};
        restless.addMethod("/v2/search", "GET", MetadataResource.class, "search", !allowAll, searchParams);
        restless.addMethod("/v2/search", "POST", MetadataResource.class, "search", !allowAll, searchParams);
    }

    public static void search(String keyword, String callback, IRestlessContext ctx) throws IOException {
        HttpServletResponse res = ctx.getResponse();
        ServletUtils.headers((HttpServletResponse)res, (int)200, (long)1L, (String)"text/html");
        PrintWriter w = res.getWriter();
        GaeSonicDB.INSTANCE.search(keyword);
        SonicMetadataResult smr = GaeSonicDB.INSTANCE.search(keyword);
        ((Writer)w).write("<h1>Results</h1>");
        ((Writer)w).write("<h2>Used Subjects</h2>");
        for (String s : smr.subject.getUsedValues()) {
            ((Writer)w).write(s + ", ");
        }
        ((Writer)w).write("<br/>\n");
        ((Writer)w).write("<h2>Used Categories</h2>");
        for (String s : smr.category.getUsedValues()) {
            ((Writer)w).write(s + ", ");
        }
        ((Writer)w).write("<br/>\n");
        ((Writer)w).write("<h2>Used Actions</h2>");
        for (String s : smr.action.getUsedValues()) {
            ((Writer)w).write(s + ", ");
        }
        ((Writer)w).write("<br/>\n");
        ((Writer)w).write("<h2>Used Labels</h2>");
        for (String s : smr.label.getUsedValues()) {
            ((Writer)w).write(s + ", ");
        }
        ((Writer)w).write("<br/>\n");
        ((Writer)w).write("<h2>Used Sources</h2>");
        for (String s : smr.source.getUsedValues()) {
            ((Writer)w).write(s + ", ");
        }
        ((Writer)w).write("<br/>\n");
        ((Writer)w).flush();
        ((Writer)w).close();
    }
}

