/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import com.google.common.cache.Cache;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.impl.gae.InstanceContext;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.DatastoreFailureException;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

public class UniCache<T> {
    public static final Logger log = LoggerFactory.getLogger(UniCache.class);
    private CacheEntryHandler<T> entryHandler;
    private String kindName;

    public UniCache(CacheEntryHandler<T> entryHandler) {
        this(entryHandler, "XCACHE");
    }

    public UniCache(CacheEntryHandler<T> entryHandler, String kindName) {
        this.entryHandler = entryHandler;
        this.kindName = kindName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, T value, StorageOptions storeOpts) {
        if (storeOpts.instanceSize > 0) {
            Cache<String, Object> instanceCache;
            Cache<String, Object> cache = instanceCache = InstanceContext.getInstanceCache();
            synchronized (cache) {
                instanceCache.put((Object)key, value);
            }
        }
        if (storeOpts.memcache) {
            Serializable memcacheValue = this.entryHandler.toSerializable(value);
            XGae.get().memcache().put((Object)key, (Object)memcacheValue);
        }
        if (storeOpts.datastore) {
            SKey datastoreKey = this.createCacheKey(key);
            try {
                SEntity entity = this.entryHandler.toEntity(datastoreKey, value);
                XGae.get().datastore().sync().putEntity(entity);
            }
            catch (ConcurrentModificationException cme) {
            }
            catch (DatastoreFailureException e) {
                log.warn("Could not cache " + key, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String key, StorageOptions storeOpts) {
        Object o;
        if (storeOpts.instanceSize > 0) {
            Cache<String, Object> instanceCache = InstanceContext.getInstanceCache();
            Object o2 = null;
            Cache<String, Object> cache = instanceCache;
            synchronized (cache) {
                o2 = instanceCache.getIfPresent((Object)key);
            }
            if (o2 != null) {
                log.debug("Return '" + key + "' from instance cache");
                return (T)o2;
            }
        }
        if (storeOpts.memcache && (o = XGae.get().memcache().get((Object)key)) != null) {
            log.debug("Return '" + key + "' from memcache");
            return this.entryHandler.fromSerializable((Serializable)o);
        }
        if (storeOpts.datastore) {
            SKey datastoreKey = this.createCacheKey(key);
            SEntity entity = XGae.get().datastore().sync().getEntity(datastoreKey);
            if (entity != null) {
                log.debug("Return '" + key + "' from datastore entity");
                return this.entryHandler.fromEntity(entity);
            }
        }
        log.debug(key + " not found in any cache. Opts: " + storeOpts);
        return null;
    }

    private SKey createCacheKey(String s) {
        return XGae.get().datastore().createKey(this.kindName, s);
    }

    public static interface CacheEntryHandler<T>
    extends DatastoreEntryHandler<T>,
    MemcacheEntryHandler<T> {
    }

    public static interface MemcacheEntryHandler<T> {
        public Serializable toSerializable(T var1);

        public T fromSerializable(Serializable var1);
    }

    public static interface DatastoreEntryHandler<T> {
        public SEntity toEntity(SKey var1, T var2);

        public T fromEntity(SEntity var1);
    }

    public static class StorageOptions
    implements Serializable {
        private static final long serialVersionUID = 9163196946298146291L;
        int instanceSize;
        boolean memcache;
        boolean datastore;
        boolean computeIfNull;

        @Deprecated
        public static StorageOptions create(boolean instance, boolean memcache, boolean datastore) {
            StorageOptions so = new StorageOptions();
            so.instanceSize = instance ? 10 : 0;
            so.memcache = memcache;
            so.datastore = datastore;
            return so;
        }

        public static StorageOptions create(int instanceSize, boolean memcache, boolean datastore, boolean computeIfNull) {
            StorageOptions so = new StorageOptions();
            so.instanceSize = instanceSize;
            so.memcache = memcache;
            so.datastore = datastore;
            so.computeIfNull = computeIfNull;
            return so;
        }

        public String toString() {
            return "instance:" + this.instanceSize + "," + "memcache:" + this.memcache + "," + "datastore:" + this.datastore + " computeIfNull?" + this.computeIfNull;
        }

        public boolean isComputeIfNull() {
            return this.computeIfNull;
        }
    }
}

