/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.io.Serializable;
import org.xydra.persistence.ModelRevision;

public class GaeModelRevision
implements Serializable {
    private static final long serialVersionUID = -6269753819062518229L;
    private long lastSilentCommitted;
    private ModelRevision modelRev;

    public static final GaeModelRevision createGaeModelRevDoesNotExistYet() {
        return new GaeModelRevision(ModelRevision.MODEL_DOES_NOT_EXIST_YET.revision(), ModelRevision.MODEL_DOES_NOT_EXIST_YET);
    }

    public GaeModelRevision(long lastSilentCommitted, ModelRevision modelRev) {
        assert (lastSilentCommitted >= -1L);
        assert (modelRev != null);
        this.lastSilentCommitted = lastSilentCommitted;
        this.modelRev = modelRev;
    }

    public long getLastSilentCommitted() {
        return this.lastSilentCommitted;
    }

    public ModelRevision getModelRevision() {
        return this.modelRev;
    }

    void setLastSilentCommittedIfHigher(long lastSilentCommitted) {
        if (lastSilentCommitted > this.lastSilentCommitted) {
            this.lastSilentCommitted = lastSilentCommitted;
        }
    }

    public void clear() {
        this.lastSilentCommitted = -1L;
        this.modelRev = ModelRevision.MODEL_DOES_NOT_EXIST_YET;
    }

    void setCurrentModelRevisionIfRevIsHigher(ModelRevision modelRev) {
        assert (modelRev != null);
        if (this.modelRev == null) {
            this.modelRev = modelRev;
        } else if (modelRev.revision() > this.modelRev.revision()) {
            this.modelRev = modelRev;
        }
    }

    public String toString() {
        return this.getModelRevision() + "; silentCommit:" + this.lastSilentCommitted;
    }
}

