/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.XFieldCommand;
import org.xydra.base.change.XModelCommand;
import org.xydra.base.change.XObjectCommand;
import org.xydra.base.change.XRepositoryCommand;
import org.xydra.base.change.XTransaction;
import org.xydra.base.rmof.XRevWritableField;
import org.xydra.base.rmof.XStateWritableField;
import org.xydra.base.rmof.XStateWritableObject;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.ng.ContextInTxn;
import org.xydra.store.impl.gae.ng.GaeModelPersistenceNG;

public class CheckResult {
    private final String debugHint;
    private final ContextInTxn ctxInTxn;
    private final GaeChange.Status status;
    private final XId actorId;
    private final boolean inTransaction;

    public static CheckResult failed(String explanation) {
        GaeModelPersistenceNG.log.info("Command failed. Reason: '" + explanation + "'");
        return new CheckResult(GaeChange.Status.FailedPreconditions, null, null, false, explanation);
    }

    public static CheckResult successCreatedField(XObjectCommand command, long revBeforeTxn, ContextInTxn ctxInTxn, GaeChange change, boolean inTransaction) {
        XStateWritableObject objectInTxn = ctxInTxn.getObject(command.getChangedEntity().getObject());
        XStateWritableField newField = objectInTxn.createField(command.getChangedEntity().getField());
        if (newField instanceof XRevWritableField) {
            ((XRevWritableField)newField).setRevisionNumber(revBeforeTxn);
        }
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, inTransaction, null);
    }

    public static CheckResult successCreatedModel(XRepositoryCommand command, GaeChange change, ContextInTxn ctxInTxn) {
        ctxInTxn.setExists(true);
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, false, null);
    }

    public static CheckResult successCreatedObject(XModelCommand command, GaeChange change, ContextInTxn ctxInTxn, boolean inTransaction) {
        ctxInTxn.createObject(command.getChangedEntity().getObject());
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, inTransaction, null);
    }

    public static CheckResult successNoChange(String explanation) {
        GaeModelPersistenceNG.log.info("+++ NoChange. Reason: " + explanation);
        return new CheckResult(GaeChange.Status.SuccessNochange, null, null, false, explanation);
    }

    public static CheckResult successRemovedField(XObjectCommand objectCommand, GaeChange change, ContextInTxn ctxInTxn, boolean inTransaction) {
        ctxInTxn.getObject(objectCommand.getChangedEntity().getObject()).removeField(objectCommand.getChangedEntity().getField());
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, inTransaction, null);
    }

    public static CheckResult successRemovedModel(XRepositoryCommand command, GaeChange change, ContextInTxn ctxInTxn) {
        ctxInTxn.setExists(false);
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, false, null);
    }

    public static CheckResult successRemovedObject(XModelCommand command, GaeChange change, ContextInTxn ctxInTxn, boolean inTransaction) {
        ctxInTxn.removeObject(command.getChangedEntity().getObject());
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, inTransaction, null);
    }

    public static CheckResult successTransaction(XTransaction transaction, GaeChange change, ContextInTxn ctxInTxn) {
        return new CheckResult(ctxInTxn.hasChanges() ? GaeChange.Status.SuccessExecuted : GaeChange.Status.SuccessNochange, change.getActorId(), ctxInTxn, true, null);
    }

    public static CheckResult successValue(XFieldCommand command, GaeChange change, ContextInTxn ctxInTxn, boolean inTransaction) {
        XAddress a = command.getChangedEntity();
        ctxInTxn.getObject(a.getObject()).getField(a.getField()).setValue(command.getValue());
        return new CheckResult(GaeChange.Status.SuccessExecuted, change.getActorId(), ctxInTxn, inTransaction, null);
    }

    public CheckResult(GaeChange.Status status, XId actorId, ContextInTxn contextInTxn, boolean inTransaction, String explanation) {
        XyAssert.xyAssert((status != null ? 1 : 0) != 0);
        assert (status != null);
        XyAssert.xyAssert((boolean)status.isCommitted(), (Object)((Object)status));
        this.status = status;
        this.actorId = actorId;
        this.ctxInTxn = contextInTxn;
        this.inTransaction = inTransaction;
        this.debugHint = explanation;
    }

    public String getDebugHint() {
        return this.debugHint;
    }

    public ContextInTxn getExecutionContextInTxn() {
        return this.ctxInTxn;
    }

    public GaeChange.Status getStatus() {
        return this.status;
    }

    public String toString() {
        return (Object)((Object)this.status) + " " + (this.debugHint == null ? "" : this.debugHint) + " actor:" + this.actorId + " inTxn?" + this.inTransaction + " see also ctxInTxn";
    }

    public XId getActorId() {
        return this.actorId;
    }

    public boolean inTransaction() {
        return this.inTransaction;
    }
}

