/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import org.xydra.sharedutils.XyAssert;

public class Interval {
    long end;
    long start;

    public Interval(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public void adjustStartToFitSizeIfNecessary(long newSize) {
        if (this.size() > newSize) {
            this.start = this.end - newSize + 1L;
        }
        XyAssert.xyAssert((this.size() <= newSize ? 1 : 0) != 0, (String)"Interval is %s but should be %s", (Object[])new Object[]{this.size(), newSize});
    }

    public Interval copy() {
        return new Interval(this.start, this.end);
    }

    public boolean isEmpty() {
        return this.start > this.end;
    }

    public long size() {
        long sizeComputed = this.end - this.start + 1L;
        if (sizeComputed < 0L) {
            return Long.MAX_VALUE;
        }
        return Math.max(0L, sizeComputed);
    }

    public Interval moveRight() {
        return new Interval(this.end + 1L, this.end + this.size());
    }

    public Interval moveRightAndShrinkToKeepEndMaxAt(long maxEnd) {
        Interval i = this.moveRight();
        if (maxEnd < i.end) {
            i.end = maxEnd;
        }
        return i;
    }

    public String toString() {
        return "[" + this.start + "," + this.end + "; size=" + this.size() + "]";
    }

    public Interval getSubInterval(int maxSize) {
        if (this.size() <= (long)maxSize) {
            return this.copy();
        }
        return new Interval(this.start, this.start + (long)maxSize - 1L);
    }

    public Interval firstHalf() {
        return new Interval(this.start, this.start + (this.size() + 1L) / 2L - 1L);
    }

    public static void main(String[] args) {
        System.out.println(new Interval(2L, 5L).getSubInterval(10));
    }
}

