/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.pipe.buffer.FourBuffer;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class PreStringTokenPipe2
extends AbstractTokenPipe
implements ITokenPipe {
    private static final char CHAR_NEWLINE = '\n';
    private static final char CHAR_DOUBLE_QUOTE = '\"';
    private static final char CHAR_BRACE_OPEN = '{';
    private static final char CHAR_BRACE_CLOSE = '}';
    private static final String PRE_END = "}}}";
    private static final String PRE_START = "{{{";
    private static final String STRING_SINGLELINE_DELIM = "\"";
    private static final String STRING_MULTILINE_DELIM = "\"\"\"";
    private Mode mode;
    private FourBuffer fourBuffer;
    private static final Logger log = LoggerFactory.getLogger(PreStringTokenPipe2.class);

    public String getLabel() {
        return "pre-string";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"document"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"document", "pre", "string", "chunk"};
    }

    public void onBeforeDocument() {
        this.fourBuffer = new FourBuffer(this.getLabel());
    }

    public void onBeforeContentToken(ITokenStream stream, IToken token) {
        assert (token.getType().equals("document"));
        assert (token.getChars() != null) : token;
        token.addContext(this.getLabel(), "processed");
        this.mode = Mode.Block;
    }

    public void onContentCodepoint(ITokenStream stream, int c, int i, IToken token) {
        if (log.isTraceEnabled()) {
            log.trace("NEXT codePoint " + c + "='" + (char)c + "' at " + i + " with fourBuffer=" + this.fourBuffer);
        }
        assert (this.mode != null);
        switch (this.mode) {
            case Block: {
                if (c == 123) {
                    if (this.fourBuffer.openTagCanMatch(PRE_START)) {
                        this.fourBuffer.appendOpenTagMarker(c);
                        if (!this.fourBuffer.openTagMatches(PRE_START)) break;
                        this.mode = Mode.PreStarted;
                        break;
                    }
                    this.fourBuffer.discardTagAndAppend(c);
                    break;
                }
                if (c == 34) {
                    if (this.fourBuffer.openTagCanMatch(STRING_MULTILINE_DELIM)) {
                        this.fourBuffer.appendOpenTagMarker(c);
                        break;
                    }
                    this.fourBuffer.discardTagAndAppend(c);
                    break;
                }
                if (this.fourBuffer.openTagMatches(STRING_SINGLELINE_DELIM) || this.fourBuffer.openTagMatches(STRING_MULTILINE_DELIM)) {
                    assert (this.fourBuffer.canGetTagContent());
                    this.mode = Mode.StringStarted;
                    this.fourBuffer.appendTagContent(c);
                    break;
                }
                this.fourBuffer.discardTagAndAppend(c);
                break;
            }
            case PreStarted: {
                assert (this.fourBuffer.canGetTagContent());
                if (c == 125) {
                    if (this.fourBuffer.closeTagCanMatch(PRE_END)) {
                        this.fourBuffer.appendCloseTagMarker(c);
                        if (!this.fourBuffer.closeTagMatches(PRE_END)) break;
                        this.fourBuffer.fireTokens(stream, "chunk", "pre");
                        this.mode = Mode.Block;
                        break;
                    }
                    this.fourBuffer.discardTagAndAppend(c);
                    this.mode = Mode.Block;
                    break;
                }
                this.fourBuffer.disardCloseTagAndAppend(c);
                break;
            }
            case StringStarted: {
                assert (this.fourBuffer.canGetTagContent()) : "" + this.fourBuffer;
                if (c == 34) {
                    if (this.fourBuffer.closeTagCanMatch(STRING_MULTILINE_DELIM)) {
                        this.fourBuffer.appendCloseTagMarker(c);
                        if (!this.fourBuffer.closeTagMatches(STRING_MULTILINE_DELIM)) break;
                        this.fourBuffer.fireTokens(stream, "chunk", "pre");
                        this.mode = Mode.Block;
                        break;
                    }
                    this.fourBuffer.discardTagAndAppend(c);
                    this.mode = Mode.Block;
                    break;
                }
                if (c == 10) {
                    if (!this.fourBuffer.openTagMatches(STRING_SINGLELINE_DELIM)) break;
                    this.fourBuffer.discardTagAndAppend(c);
                    this.mode = Mode.Block;
                    break;
                }
                if (this.fourBuffer.isClosingTag()) {
                    if (this.fourBuffer.openTagMatches(STRING_SINGLELINE_DELIM) && this.fourBuffer.closeTagMatches(STRING_SINGLELINE_DELIM)) {
                        this.fourBuffer.fireTokens(stream, "chunk", "string");
                        this.mode = Mode.Block;
                        this.fourBuffer.appendPlainContent(c);
                        break;
                    }
                    if (this.fourBuffer.openTagMatches(STRING_MULTILINE_DELIM) && this.fourBuffer.closeTagMatches(STRING_MULTILINE_DELIM)) {
                        this.fourBuffer.fireTokens(stream, "chunk", "string");
                        this.mode = Mode.Block;
                        this.fourBuffer.appendPlainContent(c);
                        break;
                    }
                    this.fourBuffer.discardTagAndAppend(c);
                    this.mode = Mode.Block;
                    this.fourBuffer.appendPlainContent(c);
                    break;
                }
                this.fourBuffer.appendTagContent(c);
            }
        }
    }

    public void onToken(ITokenStream stream, IToken token) {
        if (token.getType().equals("document")) {
            switch (token.getKind()) {
                case Start: {
                    stream.fireToken(token);
                    break;
                }
                case Content: {
                    break;
                }
                case End: {
                    stream.fireToken(token);
                }
            }
        }
    }

    public void onAfterContentToken(ITokenStream stream, IToken token) {
        this.fourBuffer.discardTagAndFireRemainder(stream, "chunk");
    }

    static enum Mode {
        Block,
        StringStarted,
        PreStarted;

    }
}

