/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.appground.server.store;

import org.xydra.base.XId;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.access.XAccessControlManager;
import org.xydra.store.access.XAuthenticationDatabase;
import org.xydra.store.access.XAuthorisationManager;
import org.xydra.store.access.XGroupDatabaseWithListeners;
import org.xydra.store.access.impl.memory.CachingOrMemoryAuthenticationDatabase;
import org.xydra.store.access.impl.memory.MemoryAuthorisationManager;
import org.xydra.store.access.impl.memory.MemoryGroupDatabase;

public class AppAccessControlManager
implements XAccessControlManager {
    private static final Logger log = LoggerFactory.getLogger(AppAccessControlManager.class);
    private XAuthorisationManager authorisationManager;
    private MemoryGroupDatabase groups;
    private XAuthenticationDatabase authenticationDatabase;

    public XAuthenticationDatabase getAuthenticationDatabase() {
        if (this.authenticationDatabase == null) {
            this.authenticationDatabase = new CachingOrMemoryAuthenticationDatabase(null);
        }
        return this.authenticationDatabase;
    }

    public synchronized XAuthorisationManager getAuthorisationManager() {
        if (this.authorisationManager == null) {
            this.groups = new MemoryGroupDatabase();
            this.authorisationManager = new MemoryAuthorisationManager((XGroupDatabaseWithListeners)this.groups);
        }
        return this.authorisationManager;
    }

    public void init() {
    }

    public boolean isAuthenticated(XId actorId, String passwordHash) {
        if (actorId.toString().toLowerCase().equals("admin")) {
            return Env.get().conf().getString("adminPasswordHash").equals(passwordHash);
        }
        String rightHash = this.getAuthenticationDatabase().getPasswordHash(actorId);
        if (passwordHash.equals(rightHash)) {
            log.debug("Authenticated '" + actorId + "'");
            return true;
        }
        log.warn("Failed to authenticate '" + actorId + "' with passwordHash '" + passwordHash + "'");
        this.getAuthenticationDatabase().incrementFailedLoginAttempts(actorId);
        return false;
    }
}

