/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common;

import com.calpano.kgif.io.IFileFormat;
import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.impl.Kgif1_1_0_Importer;
import com.calpano.kgif.io.rdf.NTriplesImporter;
import com.calpano.kgif.io.rdf.RdfXmlImporter;
import java.util.HashSet;
import java.util.Set;

public class KnownKgifImporter {
    public static Set<IKgifStreamImporter> importer = new HashSet<IKgifStreamImporter>();

    public static IKgifStreamImporter getKgifImporter(IFileFormat fileFormat) {
        for (IKgifStreamImporter im : importer) {
            if (!im.getFileFormat().equals((Object)fileFormat)) continue;
            return im;
        }
        return null;
    }

    public static void init() {
        importer.add(new NTriplesImporter());
        importer.add(new RdfXmlImporter());
        importer.add(new Kgif1_1_0_Importer());
    }

    public static IKgifStreamImporter getKgifImporter(String filenameOrExtension) {
        for (IKgifStreamImporter im : importer) {
            String[] exts = im.getFileFormat().getExtensions();
            for (int j = 0; j < exts.length; ++j) {
                if (!filenameOrExtension.endsWith(exts[j])) continue;
                return im;
            }
        }
        return null;
    }

    public static boolean isKnownImportFormat(IFileFormat fileFormat) {
        return KnownKgifImporter.getKgifImporter(fileFormat) != null;
    }

    public static Set<IKgifStreamImporter> getKnownImporter() {
        return importer;
    }

    static {
        KnownKgifImporter.init();
    }
}

