/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.util.CleanXML;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class NoUnicodeReplacementCharFilterReader
extends FilterReader {
    public static final int UNICODE_REPLACEMENT_CHARACTER = 65533;

    public static void main(String[] args) {
        assert (CleanXML.isValidXmlContentChar((int)65533));
    }

    public NoUnicodeReplacementCharFilterReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read(char[] charbuf, int offset, int length) throws FoundUnicodeReplacementCharException, IOException {
        int read = super.read(charbuf, offset, length);
        if (read > 0) {
            for (int i = offset; i < offset + read; ++i) {
                char c = charbuf[i];
                if (c != '\ufffd') continue;
                FoundUnicodeReplacementCharException e = new FoundUnicodeReplacementCharException("Found unicode replacement character in stream. Your stream decoding is likely wrong.");
                e.setCharbuf(charbuf);
                throw e;
            }
        }
        return read;
    }

    public static class FoundUnicodeReplacementCharException
    extends IllegalArgumentException {
        private char[] charbuf;

        public FoundUnicodeReplacementCharException() {
        }

        public FoundUnicodeReplacementCharException(String s) {
            super(s);
        }

        public FoundUnicodeReplacementCharException(String message, Throwable cause) {
            super(message, cause);
        }

        public FoundUnicodeReplacementCharException(Throwable cause) {
            super(cause);
        }

        public char[] getCharBuf() {
            return this.charbuf;
        }

        public void setCharbuf(char[] charbuf) {
            this.charbuf = charbuf;
        }
    }
}

