/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.rdf.RdfCommon;
import com.calpano.kgif.io.rdf.RdfHandler2Kgif;
import com.calpano.kgif.v1_1_0.write.WritingEntityHandler;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.texthtml.text.Unicodes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.openrdf.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.openrdf.sail.memory.MemoryStore;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class RdfBuiltins {
    private static final Logger log = LoggerFactory.getLogger(RdfBuiltins.class);

    public static void dumpOpenRdfBuiltinsToFile() throws RepositoryException, RDFHandlerException, IOException {
        SailRepository repo = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new MemoryStore()));
        repo.initialize();
        File f = new File("src/main/resources/rdfs-openrdf/items.kgif.xml");
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, Unicodes.UTF8);
        RdfHandler2Kgif handler = new RdfHandler2Kgif("rdfs-builtins", null);
        handler.entityHandler = new WritingEntityHandler((Writer)w);
        handler.sourceName = "RdfBuiltins via OpenRDF.ForwardChainingRDFSInferencer";
        handler.setProgressReporter(IoProgressReporter.createOnLogInfo((Logger)log));
        handler.startRDF();
        RepositoryConnection conn = repo.getConnection();
        for (Map.Entry<String, String> e : RdfCommon.NS_MAP_DEFAULTS.entrySet()) {
            conn.setNamespace(e.getKey(), e.getValue());
        }
        RepositoryResult nsIt = conn.getNamespaces();
        while (nsIt.hasNext()) {
            Namespace ns = (Namespace)nsIt.next();
            handler.handleNamespace(ns.getPrefix(), ns.getName());
        }
        RepositoryResult it = conn.getStatements(null, null, null, true, new Resource[0]);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            handler.handleStatement(s);
        }
        conn.close();
        handler.endRDF();
    }
}

