/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.gaeutils;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.client.ClientProtocolException;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpGet;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.xydra.core.serialize.Base64;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.gaeutils.AboutAppEngine;

public class UniversalUrlFetch {
    private static final Logger log = LoggerFactory.getLogger(UniversalUrlFetch.class);

    public static int callUrl(String urlStr, String username, String password, boolean async) throws IOException {
        log.info("Calling URL '" + urlStr + "'");
        boolean doBasicAuth = username != null && password != null;
        String encodedAuth = null;
        if (doBasicAuth) {
            byte[] auth = Base64.utf8((String)(username + ":" + password));
            encodedAuth = Base64.encode((byte[])auth);
        }
        if (AboutAppEngine.onAppEngine()) {
            URLFetchService service = URLFetchServiceFactory.getURLFetchService();
            URL u = new URL(urlStr);
            HTTPRequest request = new HTTPRequest(u, HTTPMethod.GET);
            if (doBasicAuth) {
                request.addHeader(new HTTPHeader("Authorization", "Basic " + encodedAuth));
            }
            Future future = service.fetchAsync(new URL(urlStr));
            try {
                return ((HTTPResponse)future.get()).getResponseCode();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet request = new HttpGet(urlStr);
        if (doBasicAuth) {
            request.setHeader("Authorization", "Basic " + encodedAuth);
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            int responseCode = response.getStatusLine().getStatusCode();
            request.abort();
            return responseCode;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
    }
}

