/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.server;

import de.xam.desktop.Desktop;
import de.xam.dwz1.server.BaseDenkWerkZeugServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.ProtectionDomain;
import org.xydra.conf.IConfig;
import org.xydra.log.api.Logger;

public class LocalMachine {
    public static File loadUserConf(IConfig conf, Logger log) {
        try {
            String appName = conf.getString("appName");
            return Desktop.readUserConf((String)appName, (IConfig)conf);
        }
        catch (IOException e) {
            log.warn("Could not load user config", (Throwable)e);
            return null;
        }
    }

    static void logAndSysout(String msg, Logger log) {
        log.info(msg);
        System.out.println(msg);
    }

    public static File writeUserConf(IConfig conf) {
        try {
            String appName = conf.getString("appName");
            return Desktop.writeUserConf((String)appName, (IConfig)conf);
        }
        catch (IOException e) {
            BaseDenkWerkZeugServer.log.warn("Could not save user config", (Throwable)e);
            return null;
        }
    }

    public static String getAutoDiscoveredWebAppDocRoot(Logger log) {
        assert (log != null);
        ProtectionDomain domain = BaseDenkWerkZeugServer.class.getProtectionDomain();
        URL locationURL = domain.getCodeSource().getLocation();
        log.info("Discovered server was loaded from URL = " + locationURL);
        assert (locationURL.toString().startsWith("file:")) : "Should start with 'file:' but is " + locationURL;
        boolean runsFromEclipse = locationURL.toString().contains("/target/classes");
        boolean runsFromJar = locationURL.toString().endsWith(".jar");
        log.info((runsFromJar ? "Runs from a jar" : "Does not run from a jar") + "; " + (runsFromEclipse ? "Runs from Eclipse" : "Runs not from Eclipse") + ".");
        String docRootUrlString = null;
        if (runsFromJar) {
            docRootUrlString = "jar:" + locationURL.toString() + "!/";
        }
        if (runsFromEclipse) {
            try {
                URI locationURI = locationURL.toURI().normalize();
                File srcDocRoot = new File(locationURI);
                File maxDocRoot = new File(srcDocRoot, "/../../src/main/webapp");
                docRootUrlString = maxDocRoot.toURI().normalize().toURL().toString();
                File webXml = new File(maxDocRoot, "WEB-INF/web.xml");
                try {
                    assert (webXml.exists()) : "Could not find " + webXml.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (URISyntaxException e) {
                LocalMachine.logAndSysout("Could not parse '" + locationURL + "'", log);
                throw new RuntimeException(e);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return docRootUrlString;
    }
}

