/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui;

import com.calpano.common.server.util.DebugMode;
import com.calpano.common.server.util.UrlUtils;
import de.xam.dwz1.webgui.RestOutput;
import de.xam.dwz1.webgui.RouterBuilder;
import de.xam.dwz1.webgui.server.about.AboutResource;
import de.xam.dwz1.webgui.server.bootgui.BootGuiResource;
import de.xam.dwz1.webgui.server.ext.ExtResource;
import de.xam.dwz1.webgui.server.file.FileResource;
import de.xam.dwz1.webgui.server.guide.GuideResource;
import de.xam.dwz1.webgui.server.item.ItemCommand;
import de.xam.dwz1.webgui.server.item.ItemResource;
import de.xam.dwz1.webgui.server.items.ItemsResource;
import de.xam.dwz1.webgui.server.query.QueryResource;
import de.xam.dwz1.webgui.server.shell.ShellResource;
import de.xam.dwz1.webgui.server.stats.StatsResource;
import de.xam.dwz1.webgui.server.system.SystemResource;
import de.xam.dwz1.webgui.server.tagcloud.TagCloudResource;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.texthtml.text.TextTool;
import org.xydra.base.XId;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.RestlessUnloadHandler;

public class Router {
    private static Router INSTANCE;
    private static final Logger log;
    private final String path;

    public static Router get() {
        assert (INSTANCE != null) : "restless() was not called";
        return INSTANCE;
    }

    public static synchronized void restless(Restless restless, String path) {
        restless.addUnloadHandler(new RestlessUnloadHandler(){

            public void onBeforeUnload() {
                ModuleManager.get().onBeforeUnload();
            }
        });
        INSTANCE = new Router(path);
        DebugMode.restless((Restless)restless, (String)path);
        RouterBuilder rest = new RouterBuilder(restless);
        RouterBuilder.Section _item = rest.section(ItemResource.class);
        RouterBuilder.Parameter idOrName = RouterBuilder.Parameter.withRequired("idOrName");
        RouterBuilder.Parameter output = RouterBuilder.Parameter.with("output", RestOutput.html.name());
        RouterBuilder.Parameter create = RouterBuilder.Parameter.with("create", "false");
        RouterBuilder.Parameter start = RouterBuilder.Parameter.with("start", "0");
        RouterBuilder.Parameter end = RouterBuilder.Parameter.with("end", "-1");
        RouterBuilder.Parameter version = RouterBuilder.Parameter.with("version", "-1");
        _item.GET(INSTANCE.url_item("{idOrName}")).to("renderItem").withPrepared(idOrName).with("command", ItemCommand.view.toString()).withPrepared(output, create, start, end);
        _item.GET(INSTANCE.url_item("{idOrName}", "{command}")).to("renderItem").withPrepared(idOrName).withRequired("command").withPrepared(output, create, start, end);
        _item.POST(INSTANCE.url_item_edit("{name}")).to("editPage_POST").withDefaultNull("name").withDefaultNull("text").withPrepared(start, end, version);
        RouterBuilder.Parameter itemId = RouterBuilder.Parameter.withRequired("itemId");
        _item.POST_AND_GET(INSTANCE.url_item_content("{itemId}")).to("setStringContent_POST").withPrepared(itemId).withRequired("contentString");
        RouterBuilder.Parameter attributeId = RouterBuilder.Parameter.withRequired("attributeId");
        RouterBuilder.Parameter attValue = RouterBuilder.Parameter.withDefaultNull("attValue");
        _item.POST_AND_GET(INSTANCE.url_item_attribute("{itemId}", "{attributeId}")).to("attributeSetValueById_POST").withPrepared(itemId, attributeId, attValue);
        _item.POST(INSTANCE.url_item_attributes("{itemId}")).to("attributeSetValueById_POST").withPrepared(itemId, attributeId, attValue);
        _item.POST_AND_GET(INSTANCE.url_item_property("{itemId}", "{propertyId}")).to("propertySetValueById_POST").withPrepared(itemId).withRequired("propertyId").withDefaultNull("oValue");
        _item.POST(INSTANCE.url_item_properties("{item}")).to("propertySetValueByNameOrId_POST").withRequired("item").withDefaultNull("pId").withDefaultNull("pName").withDefaultNull("oValue");
        RouterBuilder.Parameter relationId = RouterBuilder.Parameter.withRequired("relationId");
        RouterBuilder.Parameter targetId = RouterBuilder.Parameter.withRequired("targetId");
        RouterBuilder.Parameter pName = RouterBuilder.Parameter.withDefaultNull("pName");
        RouterBuilder.Parameter oName = RouterBuilder.Parameter.withDefaultNull("oName");
        _item.GET(INSTANCE.url_item_relation_delete("{itemId}", "{relationId}", "{targetId}")).to("relationRemoveTarget_POST").withPrepared(itemId, relationId, targetId);
        _item.POST(INSTANCE.url_item_relation("{itemId}", "{pId}")).to("relationAddTargetByIdNameOrId_POST").withPrepared(itemId).withRequired("pId").withPrepared(pName).withDefaultNull("oId").withPrepared(oName);
        _item.POST(INSTANCE.url_item_relations("{itemId}")).to("relationAddTargetByIdNameOrId_POST").withPrepared(itemId).withDefaultNull("pId").withPrepared(pName).withDefaultNull("oId").withPrepared(oName);
        _item.POST(INSTANCE.url_relation("{relId}")).to("relationAddSO_POST").withRequired("relId").withDefaultNull("sId").withDefaultNull("sName").withDefaultNull("oId").withDefaultNull("oName");
        RouterBuilder.Section _query = rest.section(QueryResource.class);
        _query.GET(INSTANCE.url_query_items("index")).to("queryItemsIndex").with("output", RestOutput.html);
        for (QueryResource.Command command : QueryResource.Command.values()) {
            _query.GET(INSTANCE.url_query_items(command.name())).to("queryItems").with("command", command).withDefaultNull("q").with("output", RestOutput.html).with("filter", "");
        }
        _query.GET(INSTANCE.url_query_items_autocomplete() + "prefetch").to("autocompletePrefetch").withDefaultNull("filter");
        _query.GET(INSTANCE.url_query_spo()).to("querySPOdo").with("s", "*").with("p", "*").with("o", "*").withDefaultNull("sName").withDefaultNull("pName").withDefaultNull("oName");
        _query.GET(INSTANCE.url_query_table()).to("queryTableDo").withRequired("subjects").with("predicates", "*");
        _query.GET(INSTANCE.url_query_table()).to("queryTableIndex");
        _query.GET(INSTANCE.url_query_sparql()).to("querySparql").withDefaultNull("sparql");
        RouterBuilder.Section _shell = rest.section(ShellResource.class);
        _shell.GET(INSTANCE.url_shell()).to("index").withDefaultNull("input").withDefaultNull("script");
        RouterBuilder.Section _file = rest.section(FileResource.class);
        restless.addPostMultipart(INSTANCE.url_file_upload(), FileResource.class, "upload", false, new RestlessParameter[0]);
        _file.GET(INSTANCE.url_file("{command}")).to("index").withDefaultNull("command").withDefaultNull("filename").withDefaultNull("format").withDefaultNull("_progressToken_");
        rest.section(StatsResource.class).GET(INSTANCE.url_stats()).to("index").withDefaultNull("param");
        rest.section(SystemResource.class).GET(INSTANCE.url_system()).to("index").with("command", "index").withDefaultNull("param");
        RouterBuilder.Section _ext = rest.section(ExtResource.class);
        _ext.GET(INSTANCE.url_ext("d3.json")).to("d3").withPrepared(itemId).with("maxDepth", "-1").with("maxNodes", "-1");
        _ext.GET(INSTANCE.url_graph()).to("graph").withPrepared(itemId).with("maxDepth", "-1").with("maxNodes", "-1");
        _ext.GET(INSTANCE.url_item_raw("{itemId}")).to("raw").withPrepared(itemId);
        _ext.GET(INSTANCE.url_ext("css")).to("css");
        _ext.GET(INSTANCE.url_ext("importCsv")).to("importCsv").withRequired("file").with("encoding", "utf-8");
        _ext.GET(INSTANCE.root("shutdown")).to("shutdown");
        rest.section(AboutResource.class).GET(INSTANCE.root("about")).to("about");
        RouterBuilder.Section _guide = rest.section(GuideResource.class);
        _guide.GET(INSTANCE.url_guide("{section}")).to("guide").withRequired("section");
        _guide.GET(INSTANCE.url_guide(null)).to("guide").with("section", "start");
        RouterBuilder.Section _items = rest.section(ItemsResource.class);
        rest.section(TagCloudResource.class).GET(INSTANCE.url_items_tagcloud()).to("tagcloud").with("q", "*").with("minFreq", "0").with("maxFreq", "2147483647").with("tags", "100").with("showBuiltIns", "true");
        _items.POST_AND_GET(INSTANCE.url_items("{command}")).to("items_command").withDefaultNull("command").withDefaultNull("name");
        _items.POST_AND_GET(INSTANCE.url_items()).to("items_POST").withDefaultNull("content").withDefaultNull("create");
        rest.section(BootGuiResource.class).GET(INSTANCE.root("boot")).to("boot").withDefaultNull("targetUrl");
        _guide.GET(INSTANCE.root(null)).to("guide").with("section", "start");
        rest.done();
        restless.log("CONFIG DONE");
    }

    public static void restless_surrogate_for_tests(String path) {
        INSTANCE = new Router(path);
    }

    public Router(String path) {
        this.path = path;
    }

    private String root(String relativePathWithoutSlashes) {
        return this.path + "/" + (relativePathWithoutSlashes == null ? "" : relativePathWithoutSlashes + "/");
    }

    public String url_entity_delete(String idString) {
        return this.url_item(idString, "delete");
    }

    public String url_entity_delete(XId id) {
        return this.url_entity_delete(id.toString());
    }

    public String url_ext(String path) {
        return this.root("ext") + path + "/";
    }

    public String url_file(String command) {
        assert (command != null);
        return this.root("file") + command + "/";
    }

    public String url_file(String command, String filename) {
        assert (command != null);
        return this.url_file(command) + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"filename", (Object)filename)});
    }

    public String url_file_upload() {
        return this.root("file_upload");
    }

    public String url_graph() {
        return this.root("graph");
    }

    public String url_graph_large(String entityIdStrOrName, String canvas, String maxDepth, String maxNodes) {
        return this.root("graph") + "/" + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"itemId", (Object)entityIdStrOrName), Pair.create((Object)"canvas", (Object)canvas), Pair.create((Object)"maxDepth", (Object)maxDepth), Pair.create((Object)"maxNodes", (Object)maxNodes)});
    }

    public String url_guide(String section) {
        return this.root("guide") + (section == null ? "" : section + "/");
    }

    public String url_item(String itemIdStr) {
        return this.root("item") + TextTool.urlEncode((String)itemIdStr) + "/";
    }

    public String url_item(String itemId, String command) {
        assert (itemId != null);
        if (command == null) {
            return this.url_item(itemId);
        }
        return this.root("item") + TextTool.urlEncode((String)itemId) + "/" + TextTool.urlEncode((String)command);
    }

    public String url_item(XId id) {
        return this.url_item(id.toString());
    }

    public String url_item_attribute(String itemIdString, String attIdString) {
        return this.url_item(itemIdString) + ItemCommand.attribute.toString() + "/" + TextTool.urlEncode((String)attIdString) + "/";
    }

    public String url_item_attribute(XId itemId, XId attIt) {
        return this.url_item_attribute(itemId.toString(), attIt.toString());
    }

    public String url_item_attributes(String itemIdString) {
        return this.url_item(itemIdString) + ItemCommand.attributes.toString() + "/";
    }

    public String url_item_attributes(XId itemId) {
        return this.url_item_attributes(itemId.toString());
    }

    public String url_item_content(String itemIdString) {
        return this.url_item(itemIdString) + ItemCommand.content.toString() + "/";
    }

    public String url_item_edit(String idString) {
        return this.url_item(idString, ItemCommand.edit.toString());
    }

    public String url_item_edit(String id, String start, String end) {
        return this.url_item_edit(id) + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"start", (Object)start), Pair.create((Object)"end", (Object)end)});
    }

    public String url_item_edit(XId id) {
        return this.url_item_edit(id.toString());
    }

    public String url_item_properties(String itemIdString) {
        return this.url_item(itemIdString) + ItemCommand.properties.toString() + "/";
    }

    public String url_item_properties(XId itemId) {
        return this.url_item_properties(itemId.toString());
    }

    public String url_item_property(String itemIdString, String propIdString) {
        return this.url_item(itemIdString) + ItemCommand.property.toString() + "/" + TextTool.urlEncode((String)propIdString) + "/";
    }

    public String url_item_property(XId itemId, XId propId) {
        return this.url_item_property(itemId.toString(), propId.toString());
    }

    public String url_item_raw(String itemId) {
        return this.url_item(itemId, ItemCommand.raw.toString());
    }

    public String url_item_raw(XId id) {
        return this.url_item_raw(id.toString());
    }

    public String url_item_relation(String itemIdString, String relIdString) {
        return this.url_item(itemIdString) + ItemCommand.relation.toString() + "/" + TextTool.urlEncode((String)relIdString) + "/";
    }

    public String url_item_relation(XId itemId, XId relId) {
        return this.url_item_relation(itemId.toString(), relId.toString());
    }

    public String url_item_relation_delete(String itemIdString, String relIdString, String targetIdString) {
        return this.url_item_relation(itemIdString, relIdString) + TextTool.urlEncode((String)targetIdString) + "/";
    }

    public String url_item_relation_delete(XId itemId, XId relId, XId targetId) {
        return this.url_item_relation_delete(itemId.toString(), relId.toString(), targetId.toString());
    }

    public String url_item_relations(String itemIdString) {
        return this.url_item(itemIdString) + ItemCommand.relation.toString() + "/";
    }

    public String url_item_relations(XId itemId) {
        return this.url_item_relations(itemId.toString());
    }

    public String url_items() {
        return this.root("items");
    }

    public String url_items(String command) {
        return this.url_items() + TextTool.urlEncode((String)command) + "/";
    }

    public String url_items_create(String content) {
        return this.url_items() + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"content", (Object)content), Pair.create((Object)"create", (Object)"true")});
    }

    public String url_items_tagcloud() {
        return this.url_items("tagcloud");
    }

    public String url_items_byName(String name) {
        return this.url_items(ItemsResource.Command.byName.name()) + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"name", (Object)name)});
    }

    public String url_items_tagcloud(String query) {
        return this.url_items_tagcloud() + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"q", (Object)(query == null ? "*" : query))});
    }

    private String url_query(String command) {
        return this.root("query") + TextTool.urlEncode((String)command) + "/";
    }

    public String url_query_items(String command) {
        return this.url_query("items") + TextTool.urlEncode((String)command) + "/";
    }

    public String url_query_items_autocomplete() {
        return this.url_query_items("autocomplete");
    }

    public String url_query_items_fulltext() {
        return this.url_query_items("fulltext");
    }

    public String url_query_items_fulltext(String query) {
        return this.url_query_items_fulltext() + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"q", (Object)query)});
    }

    public String url_query_items_subitems(String prefix) {
        assert (prefix != null);
        return this.url_query_items("subitems") + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"q", (Object)prefix)});
    }

    public String url_query_sparql() {
        return this.url_query("sparql");
    }

    public String url_query_spo() {
        return this.url_query("spo");
    }

    public String url_query_spo(String sId, String pId, String oId) {
        return this.url_query_spo() + UrlUtils.toQueryString((Pair[])new Pair[]{Pair.create((Object)"s", (Object)(sId == null ? "*" : sId)), Pair.create((Object)"p", (Object)(pId == null ? "*" : pId)), Pair.create((Object)"o", (Object)(oId == null ? "*" : oId))});
    }

    public String url_query_table() {
        return this.url_query("table");
    }

    public String url_relation(String relIdString) {
        return this.root("relation") + TextTool.urlEncode((String)relIdString) + "/";
    }

    public String url_relation(XId relId) {
        return this.url_relation(relId.toString());
    }

    public String url_shell() {
        return this.root("shell");
    }

    public String url_stats() {
        return this.root("stats");
    }

    public String url_system() {
        return this.root("system");
    }

    static {
        log = LoggerFactory.getLogger(Router.class);
    }
}

