/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.item;

import de.xam.cmodel.content.CWritableBrowserRenderableContent;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.dwz1.DWZ;
import de.xam.dwz1.webgui.RenderTool;
import de.xam.dwz1.webgui.Router;
import de.xam.dwz1.webgui.server.item.ItemCommand;
import de.xam.dwz1.webgui.server.item.ItemVelocitySupport;
import de.xam.dwzmodel.DwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.CDS;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.Items;
import de.xam.kfacet.impl.wiki.WikiFacet;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.mybase.model.names.AmbiguousNameException;
import de.xam.texthtml.text.TextTool;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.id.XidCodec;
import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.core.XX;
import org.xydra.index.EnumUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;

public class ItemResource {
    private static final Logger log = LoggerFactory.getLogger(ItemResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(IRestlessContext ctx, HttpServletResponse res, String entityIdStrOrName, String command, String output, String create, String start, String end) throws IOException {
        assert (entityIdStrOrName != null);
        String canvas = ctx.getRequest().getParameter("canvas");
        String maxDepthStr = ctx.getRequest().getParameter("maxDepth");
        maxDepthStr = maxDepthStr == null ? "-1" : maxDepthStr;
        String maxNodesStr = ctx.getRequest().getParameter("maxNodes");
        String string = maxNodesStr = maxNodesStr == null ? "-1" : maxNodesStr;
        if (canvas != null && canvas.length() > 0) {
            res.sendRedirect(Router.get().url_graph_large(entityIdStrOrName, canvas, maxDepthStr, maxNodesStr));
            return;
        }
        ItemCommand itemCommand = (ItemCommand)EnumUtils.valueOf(ItemCommand.class, (String)command);
        assert (itemCommand != null);
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).readLock().lock();
        try {
            XId entityId;
            IMyBase myBase = ModuleManager.get().getMyBase();
            IItemSet itemSet = myBase.itemSet();
            try {
                entityId = XX.toId((String)entityIdStrOrName);
            }
            catch (IllegalArgumentException e) {
                if (entityIdStrOrName.length() <= 100) {
                    entityId = XidCodec.encodeAsXId((String)entityIdStrOrName, (int)100);
                }
                throw new IllegalArgumentException("Given id is too long");
            }
            assert (entityId != null);
            IEntity entity = itemSet.getEntityById(entityId);
            if (itemCommand == ItemCommand.delete) {
                IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)"WebUser", (String)"ItemResource-renderItem");
                ItemSets.deleteEntity((IItemSet)itemSet, (XId)entityId, (IChangeData)changeData);
                res.sendRedirect(Router.get().url_items_tagcloud(null));
            }
            ItemVelocitySupport velocitySupport = ItemVelocitySupport.create(ctx, entityId, entity, itemCommand);
            velocitySupport.setState(create);
            velocitySupport.setEditStart(Integer.parseInt(start));
            velocitySupport.setEditEnd(Integer.parseInt(end));
            RenderTool.renderPage(ctx, velocitySupport);
        }
        catch (Throwable throwable) {
            ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).readLock().unlock();
            throw throwable;
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).readLock().unlock();
    }

    public void editPage_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String wikiSyntax, String start, String end, String version) throws IOException {
        assert (itemIdStr != null);
        assert (itemIdStr.length() > 0);
        Integer s = start == null ? 0 : Integer.parseInt(start);
        Integer e = Integer.parseInt(end);
        Integer v = Integer.parseInt(version);
        IMyBase myBase = ModuleManager.get().getMyBase();
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).writeLock().lock();
        IItemSet itemSet = myBase.itemSet();
        XId itemId = Base.toId((String)itemIdStr);
        IChangeData changeData = ChangeDatas.createWithLastModifiedDate_Now((String)"WebUser", (String)"ItemResource");
        IItem item = itemSet.getOrCreateAndAddItem(itemId, changeData);
        String newContent = wikiSyntax == null ? "" : wikiSyntax;
        ModuleManager.get().getWikiFacet().setWikiSourceAndVersion(item, newContent, s.intValue(), e.intValue(), (long)v.intValue());
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).writeLock().unlock();
        res.sendRedirect(Router.get().url_item(itemId));
    }

    public void propertySetValueById_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String pIdStr, String oValue) throws IOException {
        assert (ItemResource.isNotNullOrEmpty(pIdStr));
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        DWZ.get();
        XId itemId = DwzModel.toRawId((String)itemIdStr);
        IItem item = ModuleManager.get().getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            throw new RuntimeException("Found no item with id '" + itemId + "'");
        }
        assert (item != null);
        DWZ.get();
        XId propId = DwzModel.toRawId((String)pIdStr);
        XStringValue pv = ItemResource.isNotNullOrEmpty(oValue) ? XV.toValue((String)oValue) : null;
        item.setProperty(propId, (XValue)pv, ChangeDatas.createWithLastModifiedDate_Now((String)"WebUser", (String)"ItemResource-propertySetValueById_POST"));
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        ItemResource.sendRedirectToRefererOrViewItem(ctx, itemId);
    }

    private static void sendRedirectToRefererOrViewItem(IRestlessContext ctx, XId itemId) throws IOException {
        String referer = ctx.getRequest().getHeader("referer");
        if (referer != null) {
            ctx.getResponse().sendRedirect(referer);
        } else {
            ctx.getResponse().sendRedirect(Router.get().url_item(itemId));
        }
    }

    public void attributeSetValueById_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String attIdStr, String attValueString) throws IOException {
        assert (ItemResource.isNotNullOrEmpty(attIdStr));
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).writeLock().lock();
        DWZ.get();
        XId itemId = DwzModel.toRawId((String)itemIdStr);
        IItem item = ModuleManager.get().getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            throw new RuntimeException("Found no item with id '" + itemId + "'");
        }
        assert (item != null);
        DWZ.get();
        XId attId = DwzModel.toRawId((String)attIdStr);
        XStringValue attributeValue = ItemResource.isNotNullOrEmpty(attValueString) ? XV.toValue((String)attValueString) : null;
        item.setAttribute(attId, (XValue)attributeValue);
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        res.sendRedirect(Router.get().url_item(itemId));
    }

    public void setStringContent_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String contentString) throws IOException {
        if (contentString == null || contentString.equals("")) {
            throw new RuntimeException("Empty content");
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        DWZ.get();
        XId itemId = DwzModel.toRawId((String)itemIdStr);
        IMyBase myBase = ModuleManager.get().getMyBase();
        IItemSet itemSet = myBase.itemSet();
        IItem item = itemSet.getItemById(itemId);
        if (item == null) {
            throw new RuntimeException("Found no item with id '" + itemId + "'");
        }
        assert (item != null);
        CWritableBrowserRenderableContent content = item.getWritableContent();
        XValue oldValue = content.getContentValue();
        XStringValue newValue = XV.toValue((String)contentString);
        boolean changes = content.setContent((XValue)newValue, -1L);
        if (changes) {
            WikiFacet.updateAutoLinks((IMyBase)myBase, (XId)itemId, (XValue)oldValue, (XValue)newValue);
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        res.sendRedirect(Router.get().url_item(itemId.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertySetValueByNameOrId_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String pIdStr, String pName, String propValue) throws IOException {
        assert (pIdStr != null || pName != null);
        ModuleManager mm = ModuleManager.get();
        mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        try {
            XId propId;
            IMyBase myBase = mm.getMyBase();
            IChangeData changeData = ChangeDatas.createWithLastModifiedDate_Now((String)"UnknownUser", (String)"propertySetValueByNameOrId_POST");
            XId itemId = DwzModel.toRawId((String)itemIdStr);
            IItem item = myBase.itemSet().getItemById(itemId);
            assert (item != null);
            if (ItemResource.isNotNullOrEmpty(pIdStr)) {
                propId = DwzModel.toRawId((String)pIdStr);
            } else {
                IItem propItem = MyBases.getOrCreateNameItem((IMyBase)myBase, (String)pName, (IChangeData)changeData);
                if (propItem.getContent() == null) {
                    Items.setContentString((IItem)propItem, (String)pName, (long)-1L);
                }
                propId = propItem.getId();
            }
            XStringValue pv = ItemResource.isNotNullOrEmpty(propValue) ? XV.toValue((String)propValue) : null;
            item.setProperty(propId, (XValue)pv, changeData);
            ItemResource.sendRedirectToRefererOrViewItem(ctx, itemId);
        }
        catch (AmbiguousNameException e) {
            try {
                boolean caseMatters = false;
                ctx.getResponse().sendRedirect(Router.get().url_items_byName(e.getName().getCanonical(false)));
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
                throw throwable;
            }
            ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
            return;
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relationAddSO_POST(IRestlessContext ctx, HttpServletResponse res, String relIdStr, String sIdStr, String sName, String oIdStr, String oName) throws IOException {
        assert (sIdStr != null || sName != null) : "subject null";
        assert (oIdStr != null || oName != null) : "object null";
        ModuleManager mm = ModuleManager.get();
        mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        try {
            XId oId;
            XId sId;
            XId relId = DwzModel.toRawId((String)relIdStr);
            IItemSet itemSet = mm.getMyBase().itemSet();
            IItem rel = itemSet.getItemById(relId);
            assert (rel != null);
            IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)"UnknownUser", (String)"relationAddSO_POST");
            if (ItemResource.isNotNullOrEmpty(sIdStr)) {
                sId = DwzModel.toRawId((String)sIdStr);
            } else {
                assert (ItemResource.isNotNullOrEmpty(sName));
                IItem sItem = MyBases.getOrCreateNameItem((IMyBase)mm.getMyBase(), (String)sName, (IChangeData)changeData);
                sId = sItem.getId();
            }
            if (ItemResource.isNotNullOrEmpty(oIdStr)) {
                oId = DwzModel.toRawId((String)oIdStr);
            } else {
                IItem oItem = MyBases.getOrCreateNameItem((IMyBase)mm.getMyBase(), (String)oName, (IChangeData)changeData);
                oId = oItem.getId();
            }
            XId stmtId = Base.createUniqueId();
            itemSet.createAndAddStatement(stmtId, sId, relId, oId, changeData);
            res.sendRedirect(Router.get().url_item(relId));
        }
        catch (AmbiguousNameException e) {
            try {
                boolean caseMatters = false;
                ctx.getResponse().sendRedirect(Router.get().url_items_byName(e.getName().getCanonical(false)));
            }
            catch (Throwable throwable) {
                mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
                throw throwable;
            }
            mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
            return;
        }
        mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relationAddTargetByIdNameOrId_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String relationIdStr, String relationName, String targetIdStr, String targetName) throws IOException {
        assert (targetIdStr != null || targetName != null);
        ModuleManager mm = ModuleManager.get();
        mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        try {
            boolean isInverse;
            XId targetId;
            XId relId;
            XId itemId = DwzModel.toRawId((String)itemIdStr);
            IItemSet itemSet = mm.getMyBase().itemSet();
            IItem item = itemSet.getItemById(itemId);
            assert (item != null);
            IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)"UnknownUser", (String)"relationAddTargetByIdNameOrId_POST");
            if (ItemResource.isNotNullOrEmpty(relationIdStr)) {
                relId = DwzModel.toRawId((String)relationIdStr);
            } else if (ItemResource.isNotNullOrEmpty(relationName)) {
                IItem relItem = MyBases.getOrCreateNameItem((IMyBase)mm.getMyBase(), (String)relationName, (IChangeData)changeData);
                relId = relItem.getId();
            } else {
                relId = ((XId)CDS.INSTANCE.hasRelated).getId();
            }
            if (ItemResource.isNotNullOrEmpty(targetIdStr)) {
                targetId = DwzModel.toRawId((String)targetIdStr);
            } else {
                IItem targetItem = MyBases.getOrCreateNameItem((IMyBase)mm.getMyBase(), (String)targetName, (IChangeData)changeData);
                targetId = targetItem.getId();
            }
            XId stmtId = Base.createUniqueId();
            String inverseStr = ctx.getRequest().getParameter("inverse");
            boolean bl = isInverse = inverseStr != null && inverseStr.equals("true");
            if (isInverse) {
                itemSet.createAndAddStatement(stmtId, targetId, relId, itemId, changeData);
            } else {
                itemSet.createAndAddStatement(stmtId, itemId, relId, targetId, changeData);
            }
            res.sendRedirect(Router.get().url_item(itemId.toString()));
        }
        catch (AmbiguousNameException e) {
            try {
                boolean caseMatters = false;
                ctx.getResponse().sendRedirect(Router.get().url_items_byName(e.getName().getCanonical(false)));
            }
            catch (Throwable throwable) {
                mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
                throw throwable;
            }
            mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
            return;
        }
        mm.locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        return;
    }

    private static boolean isNotNullOrEmpty(String s) {
        return s != null && TextTool.trim((String)s).length() != 0;
    }

    public void relationRemoveTarget_POST(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String relationIdStr, String targetIdStr) throws IOException {
        assert (relationIdStr != null);
        assert (targetIdStr != null);
        ModuleManager mm = ModuleManager.get();
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        XId itemId = DwzModel.toRawId((String)itemIdStr);
        XId relId = DwzModel.toRawId((String)relationIdStr);
        XId targetId = DwzModel.toRawId((String)targetIdStr);
        IChangeData changeData = ChangeDatas.createWithLastModifiedDate_Now((String)"UnknownUser", (String)"relationRemoveTarget_POST");
        ItemSets.removeRelated((IItemSet)mm.getMyBase().itemSet(), (XId)itemId, (XId)relId, (XId)targetId, (IChangeData)changeData);
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        res.sendRedirect(Router.get().url_item(itemId));
    }
}

