/*
 * Decompiled with CFR 0.152.
 */
package de.xam.kgif.impl.itemset;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.IoContext;
import com.calpano.kgif.io.common.util.KgifNIO;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.KgifValidationJob;
import com.calpano.kgif.v1_1_0.gen.Content;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Label;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.write.KgifWrites;
import com.calpano.kgif.v1_1_0.write.WritingEntityHandler;
import com.google.common.collect.Sets;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.VocabularyItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.kgif.impl.itemset.KgifItemset;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifItemSetWrite {
    private static final Logger log = LoggerFactory.getLogger(KgifItemset.class);
    private static final Set<XId> ITEM_ATTRIBUTES = Sets.newHashSet((Object[])new XId[]{VocabularyCModel.ATTRIBUTE_CONTENT_VALUE, VocabularyCModel.ATTRIBUTE_CONTENT_TYPE_URI});
    private static final Set<XId> STATEMENT_ATTRIBUTES = Sets.newHashSet((Object[])new XId[]{VocabularyItemSet.PROP_STMT_SUBJECT, VocabularyItemSet.PROP_STMT_PREDICATE, VocabularyItemSet.PROP_STMT_OBJECT});
    private static final Set<XId> PROPERTY_ATTRIBUTES = Sets.newHashSet();

    protected void onMetadata(IEntity entity, XId id, Metadata metadata) {
        XValue att = entity.getAttribute(id);
        if (att == null) {
            log.warn(entity.getId() + ".attribute(" + id + ") is null. skipping.");
        } else {
            String key = id.toString();
            String value = att.toString();
            KgifWrites.appendToMetadata((Metadata)metadata, (String)key, (String)value);
        }
    }

    protected void onNode(IItem item, Node node) {
    }

    private Metadata toMetadata(IEntity entity, Set<XId> excluded) {
        Iterator attributes = entity.attributes();
        if (attributes.hasNext()) {
            Metadata metadata = new Metadata();
            while (attributes.hasNext()) {
                XId id = (XId)attributes.next();
                if (excluded.contains(id)) continue;
                this.onMetadata(entity, id, metadata);
            }
            return metadata;
        }
        return null;
    }

    private void writeItem(IItem item, Set<XId> definedIds, IEntityHandler eh, IIoContext ioContext) throws KgifReadWriteException, IOException {
        definedIds.add(item.getId());
        Node node = new Node();
        node.setId(item.getId().toString());
        Metadata metadata = this.toMetadata((IEntity)item, ITEM_ATTRIBUTES);
        if (metadata != null) {
            node.setMetadata(metadata);
        }
        Label label = new Label();
        String contentStr = item.getContent().getContentAsString();
        if (contentStr == null) {
            contentStr = item.getId().toString();
        }
        String contentTypeUri = item.getContent().getContentTypeUri();
        label.setContentType(contentTypeUri);
        label.setContent(contentStr);
        node.setLabel(label);
        this.onNode(item, node);
        eh.onNode(ioContext.refine(" itemId='" + item.getId() + "'"), node);
    }

    public void writeKGIF(IItemSet itemSet, IEntityHandler entityHandler, String fileCreationHeaderString, boolean sortByChangeDate) throws IOException {
        KgifValidationJob job = new KgifValidationJob();
        job.setRequireNodeLabels(true);
        job.setRequireUseOnlyIdsWithEntities(true);
        IEntityHandler eh = entityHandler;
        IoContext ioContext = new IoContext(null, "write");
        eh.onDocumentStart((IIoContext)ioContext);
        String toolName = "DenkWerkZeug";
        String toolVersionNumber = "1.0.3";
        Header header = KgifWrites.createHeader((String)"DenkWerkZeug", (String)"1.0.3", (String)fileCreationHeaderString);
        Map nsMap = ItemSets.getNamespaces((IItemSet)itemSet);
        Metadata fileMetadata = header.getMetadata();
        if (fileMetadata == null) {
            fileMetadata = new Metadata();
            header.setMetadata(fileMetadata);
        }
        KgifNIO.appendNamespaceMapToMetadata((Map)nsMap, (Metadata)fileMetadata);
        eh.onHeader((IIoContext)ioContext, header);
        Metadata graphMetadata = KgifWrites.createMetadata((String)"generator", (String)"DWZ-KgifMapper-writeKGIF");
        eh.onGraphStart((IIoContext)ioContext, graphMetadata);
        HashSet<XId> definedIds = new HashSet<XId>();
        HashSet<XId> usedIds = new HashSet<XId>();
        if (sortByChangeDate) {
            log.debug("Sorting ...");
            List list = ItemSets.entitiesList((IItemSet)itemSet);
            ItemSets.sortByChangeDate((List)list);
            for (IEntity entity : list) {
                if (entity instanceof IItem) {
                    this.writeItem((IItem)entity, definedIds, eh, (IIoContext)ioContext);
                    continue;
                }
                if (entity instanceof IStatement) {
                    this.writeStatement((IStatement)entity, definedIds, usedIds, eh, (IIoContext)ioContext);
                    continue;
                }
                if (entity instanceof IProperty) {
                    this.writeProperty((IProperty)entity, definedIds, eh, (IIoContext)ioContext);
                    continue;
                }
                assert (false);
            }
        } else {
            Iterator itemIt = itemSet.items();
            while (itemIt.hasNext()) {
                IItem item = (IItem)itemIt.next();
                this.writeItem(item, definedIds, eh, (IIoContext)ioContext);
            }
            Iterator stmtIt = itemSet.statements();
            while (stmtIt.hasNext()) {
                IStatement stmt = (IStatement)stmtIt.next();
                this.writeStatement(stmt, definedIds, usedIds, eh, (IIoContext)ioContext);
            }
            Iterator propIt = itemSet.properties();
            while (propIt.hasNext()) {
                IProperty prop = (IProperty)propIt.next();
                this.writeProperty(prop, definedIds, eh, (IIoContext)ioContext);
            }
        }
        eh.onGraphEnd((IIoContext)ioContext);
        eh.onDocumentEnd((IIoContext)ioContext);
    }

    public void writeKGIF(IItemSet itemSet, Writer w, String fileCreationHeaderString) throws IOException {
        WritingEntityHandler weh = new WritingEntityHandler(w);
        this.writeKGIF(itemSet, (IEntityHandler)weh, fileCreationHeaderString);
    }

    public void writeKGIF(IItemSet itemSet, IEntityHandler eh, String fileCreationHeaderString) throws IOException {
        this.writeKGIF(itemSet, eh, fileCreationHeaderString, true);
        eh.close();
    }

    private void writeProperty(IProperty prop, Set<XId> definedIds, IEntityHandler eh, IIoContext ioContext) throws KgifReadWriteException, IOException {
        definedIds.add(prop.getId());
        Property kgifProp = new Property();
        kgifProp.setId(prop.getId().toString());
        kgifProp.setSourceEntityId(prop.getSourceEntityId().toString());
        Metadata metadata = this.toMetadata((IEntity)prop, PROPERTY_ATTRIBUTES);
        if (metadata != null) {
            kgifProp.setMetadata(metadata);
        }
        kgifProp.setKey(prop.getPropertyKey().toString());
        String contentStr = prop.getContent().getContentAsString();
        if (contentStr == null) {
            contentStr = prop.getId().toString();
        }
        String contentTypeUri = prop.getContent().getContentTypeUri();
        Content content = new Content();
        content.setContentType(contentTypeUri);
        content.setContent(contentStr);
        kgifProp.setContent(content);
        eh.onProperty(ioContext, kgifProp);
    }

    private void writeStatement(IStatement stmt, Set<XId> definedIds, Set<XId> usedIds, IEntityHandler eh, IIoContext ioContext) throws KgifReadWriteException, IOException {
        definedIds.add(stmt.getId());
        Link link = new Link();
        link.setId(stmt.getId().toString());
        Metadata metadata = this.toMetadata((IEntity)stmt, STATEMENT_ATTRIBUTES);
        if (metadata != null) {
            link.setMetadata(metadata);
        }
        CTriple triple = stmt.getTriple();
        XId s = triple.s();
        XId p = triple.p();
        XId o = triple.o();
        link.setFrom(s.toString());
        link.setType(p.toString());
        link.setTo(o.toString());
        usedIds.add(s);
        usedIds.add(p);
        usedIds.add(o);
        eh.onLink(ioContext, link);
    }
}

