/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.gae.taskqueue;

import com.calpano.common.server.util.SerialisationUtils;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.gaeutils.GaeConstants;

public class GaeTaskQueueUtils {
    private static final Logger log = LoggerFactory.getLogger(GaeTaskQueueUtils.class);

    public static <T> void doLater(T value, String queueName) {
        try {
            byte[] bytes = SerialisationUtils.valueToBytes(value);
            log.info("Trying to enqueue " + bytes.length + " bytes. Max is " + GaeConstants.MAX_GAE_TASk_PAYLOAD_SIZE);
            Queue queue = QueueFactory.getQueue((String)queueName);
            try {
                GaeTaskQueueUtils.enqueueValue(queue, bytes);
            }
            catch (IllegalArgumentException e) {
                log.info("Task size too large with " + bytes.length + " bytes. Enqueing value as a task.", (Throwable)e);
                bytes = SerialisationUtils.valueToBytes(value);
                try {
                    GaeTaskQueueUtils.enqueueValue(queue, bytes);
                }
                catch (IllegalArgumentException e2) {
                    log.error("Task size too large with " + bytes.length + " bytes", (Throwable)e2);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void enqueueValue(Queue queue, byte[] bytes) throws IllegalArgumentException {
        TaskOptions task = TaskOptions.Builder.withUrl((String)"/admin/task/executeLater/").method(TaskOptions.Method.POST).payload(bytes, "x-java-objectstream");
        queue.add(task);
    }
}

