/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.util.TreeSet;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    private static final Resource[] INTEGER_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#integer"), new Resource("http://www.w3.org/2001/XMLSchema#int"), new Resource("http://www.w3.org/2001/XMLSchema#positiveInteger"), new Resource("http://www.w3.org/2001/XMLSchema#negativeInteger"), new Resource("http://www.w3.org/2001/XMLSchema#nonPositiveInteger"), new Resource("http://www.w3.org/2001/XMLSchema#nonNegativeInteger"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedInt")};
    private static final Resource[] BYTE_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#byte"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedByte")};
    private static final Resource[] SHORT_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#short"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedShort")};
    private static final Resource[] LONG_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#long"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedLong")};
    private static final Resource[] FLOAT_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#float")};
    private static final Resource[] DOUBLE_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#double"), new Resource("http://www.w3.org/2001/XMLSchema#decimal")};
    private static final TreeSet<Resource> INTEGERS = NumericLiteral.toTreeSet(new Resource[][]{INTEGER_TYPES});
    private static final TreeSet<Resource> BYTES = NumericLiteral.toTreeSet(new Resource[][]{BYTE_TYPES});
    private static final TreeSet<Resource> SHORTS = NumericLiteral.toTreeSet(new Resource[][]{SHORT_TYPES});
    private static final TreeSet<Resource> LONGS = NumericLiteral.toTreeSet(new Resource[][]{LONG_TYPES});
    private static final TreeSet<Resource> FLOATS = NumericLiteral.toTreeSet(new Resource[][]{FLOAT_TYPES});
    private static final TreeSet<Resource> DOUBLES = NumericLiteral.toTreeSet(new Resource[][]{DOUBLE_TYPES});
    public static final TreeSet<Resource> NUMBERS = NumericLiteral.toTreeSet(INTEGER_TYPES, BYTE_TYPES, SHORT_TYPES, LONG_TYPES, FLOAT_TYPES, DOUBLE_TYPES);
    public static final Resource INTEGER = new Resource("http://www.w3.org/2001/XMLSchema#integer");
    public static final Resource BYTE = new Resource("http://www.w3.org/2001/XMLSchema#byte");
    public static final Resource SHORT = new Resource("http://www.w3.org/2001/XMLSchema#short");
    public static final Resource LONG = new Resource("http://www.w3.org/2001/XMLSchema#long");
    public static final Resource FLOAT = new Resource("http://www.w3.org/2001/XMLSchema#float");
    public static final Resource DOUBLE = new Resource("http://www.w3.org/2001/XMLSchema#double");
    public static final Resource DECIMAL = new Resource("http://www.w3.org/2001/XMLSchema#decimal");
    private Number _n;

    public NumericLiteral(Number n) {
        super(n.toString(), NumericLiteral.getDatatype(n));
        this._n = n;
    }

    public NumericLiteral(Number n, Resource dt) {
        super(n.toString(), dt);
        this._n = n;
    }

    public NumericLiteral(String s, Resource dt, Number n) throws NumberFormatException {
        super(s, dt);
        this._n = n;
    }

    public static NumericLiteral getNumericLiteral(Literal l) throws ParseException {
        if (l instanceof NumericLiteral) {
            return (NumericLiteral)l;
        }
        if (l instanceof Literal) {
            try {
                Number n = NumericLiteral.parseNumber(l);
                return new NumericLiteral(l.getData(), l.getDatatype(), n);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Cannot parse NumericLiteral from " + l.toN3());
            }
        }
        throw new ParseException("Cannot parse NumericLiteral from " + l.getClass().getSimpleName() + " argument.");
    }

    public Number getNumber() {
        return this._n;
    }

    public static Number parseNumber(String s) throws NumberFormatException {
        Number n;
        try {
            n = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            n = Double.parseDouble(s);
        }
        return n;
    }

    public static Resource getDatatype(Number n) {
        if (n instanceof Integer) {
            return INTEGER;
        }
        if (n instanceof Byte) {
            return BYTE;
        }
        if (n instanceof Short) {
            return SHORT;
        }
        if (n instanceof Long) {
            return LONG;
        }
        if (n instanceof Float) {
            return FLOAT;
        }
        return DOUBLE;
    }

    public void stripSign() {
        if (this._n.doubleValue() >= 0.0) {
            return;
        }
        this._n = this._n instanceof Integer ? (Number)(this._n.intValue() * -1) : (Number)(this._n instanceof Byte ? (Number)(Byte.valueOf(this._n.byteValue()) * -1) : (Number)(this._n instanceof Short ? (Number)(Short.valueOf(this._n.shortValue()) * -1) : (Number)(this._n instanceof Long ? (Number)(Long.valueOf(this._n.longValue()) * -1L) : (Number)(this._n instanceof Float ? (Number)Float.valueOf(Float.valueOf(this._n.floatValue()).floatValue() * -1.0f) : (Number)(Double.valueOf(this._n.doubleValue()) * -1.0)))));
        this._data = this._n.toString();
    }

    private static Number parseNumber(Literal l) throws NumberFormatException {
        if (l instanceof NumericLiteral) {
            return ((NumericLiteral)l).getNumber();
        }
        Resource dt = l.getDatatype();
        if (INTEGERS.contains(dt)) {
            return Integer.parseInt(l.getData());
        }
        if (DOUBLES.contains(dt)) {
            return Double.parseDouble(l.getData());
        }
        if (LONGS.contains(dt)) {
            return Long.parseLong(l.getData());
        }
        if (FLOATS.contains(dt)) {
            return Float.valueOf(Float.parseFloat(l.getData()));
        }
        if (BYTES.contains(dt)) {
            return Byte.parseByte(l.getData());
        }
        if (SHORTS.contains(dt)) {
            return Short.parseShort(l.getData());
        }
        return Double.parseDouble(l.getData());
    }

    private static TreeSet<Resource> toTreeSet(Resource[] ... rss) {
        TreeSet<Resource> ts = new TreeSet<Resource>();
        Resource[][] arr$ = rss;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Resource[] rs;
            for (Resource r : rs = arr$[i$]) {
                ts.add(r);
            }
        }
        return ts;
    }

    public int compareTo(NumericLiteral nl) {
        double d2;
        double d1 = this._n.doubleValue();
        if (d1 == (d2 = nl.getNumber().doubleValue())) {
            return 0;
        }
        if (d1 > d2) {
            if ((int)(d1 - d2) == 0) {
                return 1;
            }
            return (int)(d1 - d2);
        }
        if ((int)(d1 - d2) == 0) {
            return -1;
        }
        return (int)(d1 - d2);
    }
}

