/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;

public class Variable
implements Node,
Serializable {
    private static final long serialVersionUID = 4927370223302416068L;
    private final String _data;
    private boolean _isExistential = false;
    public static final String JOIN_CONST_PREFIX = "y2joinvar:";

    public Variable(String data, boolean isN3) {
        this._data = isN3 ? data : (data.charAt(0) == '?' ? data : '?' + data);
    }

    public Variable(String data) {
        this(data, false);
    }

    public String toString() {
        return this._data.substring(Math.min(this._data.length(), 1), Math.max(this._data.length(), 0));
    }

    public int compareTo(Object o) {
        if (o instanceof Variable) {
            return this._data.compareTo(o.toString());
        }
        return -1;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Variable && ((Variable)o)._data.equals(this._data);
    }

    public String toN3() {
        return this._data;
    }

    public void setExistential(boolean ex) {
        this._isExistential = ex;
    }

    public boolean isExistential() {
        return this._isExistential;
    }

    public int hashCode() {
        return this._data.hashCode();
    }

    public Literal toJoinLiteral() {
        return new Literal(JOIN_CONST_PREFIX + this.toN3());
    }

    public static Variable fromJoinLiteral(Literal l) {
        if (Variable.isJoinLiteral(l)) {
            return new Variable(l.toString().substring(JOIN_CONST_PREFIX.length() + 1));
        }
        return null;
    }

    public static boolean isJoinLiteral(Literal l) {
        return l.toString().startsWith(JOIN_CONST_PREFIX);
    }

    public static boolean isJoinLiteral(Node n) {
        return n instanceof Literal && ((Literal)n).toString().startsWith(JOIN_CONST_PREFIX);
    }
}

