/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.reorder.ReorderIterator;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;

public class Reorder {
    static transient Logger _log = Logger.getLogger(Reorder.class.getName());

    public static void main(String[] args) throws IOException, ParseException {
        Option maskO = new Option("m", "where 0123 is an integer mask, out[0] = in[2], out[1] = in[3], out[2] = in[0], out[3] = in[1]\nexample: spoc => pocs, pocs => ocsp, ocsp => cspo, cspo => spoc 1230\nexample: pocs => spoc, spoc => cspo, cspo => ocsp, ocsp => pocs 3012\nexample: spoc => sopc 0213\nexample: spoc => cpso 3102");
        maskO.setArgs(1);
        maskO.setRequired(true);
        Options options = Main.getStandardOptions();
        options.addOption(maskO);
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            System.err.println("***ERROR: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        int[] mask = Reorder.getMask(cmd.getOptionValue("m"));
        InputStream is = Main.getMainInputStream(cmd);
        OutputStream os = Main.getMainOutputStream(cmd);
        int ticks = Main.getTicks(cmd);
        NxParser it = new NxParser(is);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        CallbackNxBufferedWriter cb = new CallbackNxBufferedWriter(bw);
        ReorderIterator ri = new ReorderIterator(it, mask, ticks);
        while (ri.hasNext()) {
            cb.processStatement(ri.next());
        }
        _log.info("Finished reorder. Reordered " + ri.count() + " statements.");
        is.close();
        bw.close();
    }

    public static int[] getMask(String arg) {
        int[] reorder = new int[arg.length()];
        for (int i = 0; i < reorder.length; ++i) {
            reorder[i] = Integer.parseInt(Character.toString(arg.charAt(i)));
        }
        return reorder;
    }
}

