/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.datetime;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.datetime.XSDTime;

public class ISO8601Parser {
    private static String NO_TOKEN = "\n";

    public static GregorianCalendar parseISO8601DateTime(String s) throws DatatypeParseException {
        return ISO8601Parser.parseISO8601DateTime(s, false);
    }

    public static GregorianCalendar parseISO8601DateTime(String s, boolean tzRequired) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        String t = ISO8601Parser.parseISO8601Date(s, cal);
        if (t == null) {
            throw new DatatypeParseException("Premature end of lexical string, expecting token 'T'.", 101);
        }
        if (!t.startsWith("T")) {
            throw new DatatypeParseException("Expecting token 'T', not '" + t + "'.", 201);
        }
        String tz = ISO8601Parser.parseISO8601Time(t.substring(1), cal);
        if (tz == null) {
            if (tzRequired) {
                throw new DatatypeParseException("Premature end of lexical string, expecting token '.*(Z|(\\+|-)[0-9][0-9]:[0-9][0-9])'.", 101);
            }
        } else {
            String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
            if (nul != null) {
                throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 301);
            }
        }
        return cal;
    }

    public static GregorianCalendar parseISO8601Date(String s) throws DatatypeParseException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        String nul = ISO8601Parser.parseISO8601Date(s, cal);
        if (nul != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 302);
        }
        return cal;
    }

    private static String parseISO8601Date(String s, GregorianCalendar cal) throws DatatypeParseException {
        String mmdd = ISO8601Parser.parseISO8601Year(s, cal);
        if (mmdd == null || !mmdd.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + mmdd + "'.", 202);
        }
        String dd = ISO8601Parser.parseISO8601Month(mmdd.substring(1), cal);
        if (dd == null || !dd.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + dd + "'.", 203);
        }
        String tz = ISO8601Parser.parseISO8601Day(dd.substring(1), cal);
        if (tz == null) {
            return null;
        }
        if (tz.startsWith("T")) {
            return tz;
        }
        String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
        return nul;
    }

    public static GregorianCalendar parseISO8601YearMonth(String s) throws DatatypeParseException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        String nul = ISO8601Parser.parseISO8601YearMonth(s, cal);
        if (nul != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 303);
        }
        return cal;
    }

    private static String parseISO8601YearMonth(String s, GregorianCalendar cal) throws DatatypeParseException {
        String mm = ISO8601Parser.parseISO8601Year(s, cal);
        if (mm == null || !mm.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + mm + "'.", 204);
        }
        String tz = ISO8601Parser.parseISO8601Month(mm.substring(1), cal);
        if (tz == null) {
            return null;
        }
        String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
        return nul;
    }

    public static GregorianCalendar parseISO8601Year(String s) throws DatatypeParseException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        String tz = ISO8601Parser.parseISO8601Year(s, cal);
        if (tz == null) {
            return cal;
        }
        String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
        if (nul != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 304);
        }
        return cal;
    }

    private static String parseISO8601Year(String s, GregorianCalendar cal) throws DatatypeParseException {
        int year;
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer t = new StringTokenizer(s, "-+Z", true);
        String tok = t.nextToken();
        if (tok.equals("-")) {
            if (!t.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'YYYY'.", 102);
            }
            tok = t.nextToken();
            cal.set(0, 0);
        } else if (tok.equals("+")) {
            if (!t.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'YYYY'.", 103);
            }
            tok = t.nextToken();
        }
        if (tok.length() < 4) {
            throw new DatatypeParseException("Illegal value for YYYY '" + tok + "'. Min length is 4.", 223);
        }
        if (tok.length() > 4 && tok.startsWith("0")) {
            throw new DatatypeParseException("Illegal value for YYYY '" + tok + "'. Leading zeros only allowed for YYYY length of 4.", 223);
        }
        try {
            year = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Illegal value for YYYY '" + tok + "'.", 205);
        }
        cal.set(1, year);
        if (!t.hasMoreTokens()) {
            return null;
        }
        return t.nextToken(NO_TOKEN);
    }

    public static GregorianCalendar parseISO8601MonthDay(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        if (!s.startsWith("--")) {
            throw new DatatypeParseException("Expecting opening token '--' not '" + s + "'.", 206);
        }
        String nul = ISO8601Parser.parseISO8601MonthDay(s.substring(2), cal);
        if (nul != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 305);
        }
        return cal;
    }

    private static String parseISO8601MonthDay(String s, GregorianCalendar cal) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        String dd = ISO8601Parser.parseISO8601Month(s, cal);
        if (dd == null || !dd.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + dd + "'.", 207);
        }
        String tz = ISO8601Parser.parseISO8601Day(dd.substring(1), cal);
        if (tz == null) {
            return null;
        }
        String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
        return nul;
    }

    public static GregorianCalendar parseISO8601Month(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        if (!s.startsWith("--")) {
            throw new DatatypeParseException("Expecting opening token '--' not '" + s + "'.", 208);
        }
        if (!s.endsWith("--")) {
            throw new DatatypeParseException("Expecting closing token '--' not '" + s + "'.", 209);
        }
        String tz = ISO8601Parser.parseISO8601Month(s.substring(2, s.length() - 2), cal);
        if (tz == null) {
            return cal;
        }
        String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
        if (nul != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 306);
        }
        return cal;
    }

    private static String parseISO8601Month(String s, GregorianCalendar cal) throws DatatypeParseException {
        int mon;
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer t = new StringTokenizer(s, "-+Z", true);
        String tok = t.nextToken();
        try {
            mon = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Illegal value for MM: '" + tok + "'.", 210);
        }
        if (mon > 12 || mon < 1) {
            throw new DatatypeParseException("Illegal value for MM (>12): " + mon + ".", 401);
        }
        cal.set(2, mon - 1);
        if (!t.hasMoreTokens()) {
            return null;
        }
        return t.nextToken(NO_TOKEN);
    }

    public static GregorianCalendar parseISO8601Day(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        if (!s.startsWith("---")) {
            throw new DatatypeParseException("Expecting opening token '---' not '" + s + "'.", 211);
        }
        String tz = ISO8601Parser.parseISO8601Day(s.substring(3), cal);
        if (tz == null) {
            return cal;
        }
        String nul = ISO8601Parser.parseISO8601Timezone(tz, cal);
        if (nul != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + nul + "'.", 307);
        }
        return cal;
    }

    private static String parseISO8601Day(String s, GregorianCalendar cal) throws DatatypeParseException {
        int day;
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer t = new StringTokenizer(s, "-+TZ", true);
        String tok = t.nextToken();
        try {
            day = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Illegal value for DD: '" + tok + "'.", 212);
        }
        if (day > 31 || day < 0) {
            throw new DatatypeParseException("Illegal value for DD (>31): " + day + ".", 402);
        }
        if (cal.isSet(1)) {
            if (!ISO8601Parser.verifyDay(cal.get(1), cal.get(2) + 1, day)) {
                throw new DatatypeParseException("Illegal value for DD : " + day + " (YYYY = " + cal.get(1) + " MM = " + (cal.get(2) + 1) + ").", 412);
            }
        } else if (cal.isSet(2) && !ISO8601Parser.verifyDay(cal.get(2) + 1, day)) {
            throw new DatatypeParseException("Illegal value for DD : " + day + " (MM = " + (cal.get(2) + 1) + ").", 413);
        }
        cal.set(5, day);
        if (!t.hasMoreTokens()) {
            return null;
        }
        return t.nextToken(NO_TOKEN);
    }

    public static GregorianCalendar parseISO8601Time(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        cal.clear();
        String s1 = ISO8601Parser.parseISO8601Time(s, cal);
        if (s1 != null) {
            ISO8601Parser.parseISO8601Timezone(s1, cal);
        }
        return cal;
    }

    private static String parseISO8601Time(String s, GregorianCalendar cal) throws DatatypeParseException {
        int sec;
        int min;
        int hour;
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer t = new StringTokenizer(s, "-:.Z+", true);
        boolean allZero = false;
        String tok = t.nextToken();
        try {
            hour = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Illegal value for hh '" + tok + "'.", 213);
        }
        if (hour > 24 || hour < 0) {
            throw new DatatypeParseException("Illegal value for hh (>24) " + hour + ".", 403);
        }
        if (hour == 24) {
            allZero = true;
        }
        cal.set(11, hour);
        if (!t.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting ':mm:ss'.", 104);
        }
        tok = t.nextToken();
        if (!tok.equals(":")) {
            throw new DatatypeParseException("Expecting token ':' not '" + tok + "'.", 214);
        }
        if (!t.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting 'mm:ss'.", 105);
        }
        tok = t.nextToken();
        try {
            min = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Illegal value for mm: '" + tok + "'.", 215);
        }
        if (min > 60 || min < 0) {
            throw new DatatypeParseException("Illegal value for mm (>60): " + min + ".", 404);
        }
        if (allZero && min != 0) {
            throw new DatatypeParseException("Illegal value for mm (>0): " + min + ".", 405);
        }
        cal.set(12, min);
        if (!t.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting ':ss'.", 106);
        }
        tok = t.nextToken();
        if (!tok.equals(":")) {
            throw new DatatypeParseException("Expecting token ':' not '" + tok + "'.", 216);
        }
        if (!t.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting 'ss'.", 107);
        }
        tok = t.nextToken();
        try {
            sec = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Illegal value for ss: '" + tok + "'.", 217);
        }
        if (sec > 60 || sec < 0) {
            throw new DatatypeParseException("Illegal value for ss (>60): " + sec + ".", 406);
        }
        if (allZero && sec != 0) {
            throw new DatatypeParseException("Illegal value for ss (>0): " + sec + ".", 407);
        }
        cal.set(13, sec);
        if (!t.hasMoreTokens()) {
            return null;
        }
        tok = t.nextToken();
        if (tok.equals(".")) {
            Double f;
            tok = t.nextToken();
            try {
                f = Double.parseDouble("." + tok);
            }
            catch (NumberFormatException e) {
                throw new DatatypeParseException("Illegal value for ss: '" + tok + "'.", 218);
            }
            int msec = (int)(f * 1000.0);
            if (allZero && msec != 0) {
                throw new DatatypeParseException("Illegal value for ms (>0): " + msec + ".", 408);
            }
            cal.set(14, msec);
            if (t.hasMoreTokens()) {
                tok = t.nextToken();
            } else {
                return null;
            }
        }
        if (t.hasMoreTokens()) {
            return tok + t.nextToken(NO_TOKEN);
        }
        return tok;
    }

    private static String parseISO8601Timezone(String s, GregorianCalendar cal) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer t = new StringTokenizer(s, "-:.Z+", true);
        String tok = t.nextToken();
        if (!tok.equals("Z")) {
            int m;
            int h;
            int sign = 0;
            if (tok.equals("+")) {
                sign = 1;
            } else if (tok.equals("-")) {
                sign = -1;
            } else {
                throw new DatatypeParseException("Excepting token '+' or '-' for timezone, not '" + tok + "'.", 219);
            }
            if (!t.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'hh:mm' for TZ.", 108);
            }
            tok = t.nextToken();
            try {
                h = Integer.parseInt(tok);
            }
            catch (NumberFormatException e) {
                throw new DatatypeParseException("Illegal value for TZ hh: '" + tok + "'.", 220);
            }
            if (h > 14) {
                throw new DatatypeParseException("Illegal value for TZ hh (>14): " + h + ".", 409);
            }
            if (!t.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting ':mm' for TZ.", 109);
            }
            tok = t.nextToken();
            if (!tok.equals(":")) {
                throw new DatatypeParseException("Expecting token ':' not '" + tok + "'.", 221);
            }
            if (!t.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'mm' for TZ", 110);
            }
            tok = t.nextToken();
            try {
                m = Integer.parseInt(tok);
            }
            catch (NumberFormatException e) {
                throw new DatatypeParseException("Illegal value for TZ mm: '" + tok + "'.", 222);
            }
            if (m > 60 || m < 0) {
                throw new DatatypeParseException("Illegal value for TZ mm (>60): " + m + ".", 410);
            }
            if (h == 14 && m != 0) {
                throw new DatatypeParseException("Illegal value for TZ mm (>0,hh=14): " + m + ".", 411);
            }
            int offset = sign * (h * 1000 * 3600 + m * 1000 * 60);
            cal.set(15, offset);
        } else {
            cal.set(15, 0);
        }
        if (!t.hasMoreTokens()) {
            return null;
        }
        return t.nextToken(NO_TOKEN);
    }

    public static String getCanonicalRepresentation(GregorianCalendar cal, boolean y, boolean m, boolean d, boolean t, boolean tz) {
        StringBuffer iso8601 = new StringBuffer();
        if (y && !m && d) {
            throw new IllegalArgumentException("Must set MM if YY and DD are set");
        }
        if ((y != m || y != d) && t) {
            throw new IllegalArgumentException("If set time, must set or unset all YY MM DD");
        }
        if (t) {
            GregorianCalendar cal2 = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
            cal2.setTimeInMillis(cal.getTimeInMillis());
            cal = cal2;
        }
        if (y) {
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                iso8601.append("-" + ISO8601Parser.leadZeros(year, 4));
            } else if (year > 9999) {
                iso8601.append("+" + year);
            } else {
                iso8601.append(ISO8601Parser.leadZeros(year, 4));
            }
            if (m) {
                iso8601.append("-");
            }
        }
        if (m) {
            if (!y) {
                iso8601.append("--");
            }
            iso8601.append(ISO8601Parser.leadZeros(cal.get(2) + 1, 2));
            if (d) {
                iso8601.append("-");
            } else {
                iso8601.append("--");
            }
        }
        if (d) {
            if (!m) {
                iso8601.append("---");
            }
            iso8601.append(ISO8601Parser.leadZeros(cal.get(5), 2));
            if (t) {
                iso8601.append("T");
            }
        }
        if (t) {
            iso8601.append(ISO8601Parser.leadZeros(cal.get(11), 2) + ":");
            iso8601.append(ISO8601Parser.leadZeros(cal.get(12), 2) + ":");
            iso8601.append(ISO8601Parser.leadZeros(cal.get(13), 2));
            int milli = cal.get(14);
            if (milli != 0) {
                iso8601.append(XSDTime.removeTrailingZeros(Double.toString((double)milli / 1000.0).substring(1)));
            }
        }
        if (tz && t) {
            iso8601.append("Z");
        } else if (tz) {
            int milli = cal.get(15);
            if (milli == 0) {
                iso8601.append("Z");
            } else {
                iso8601.append(ISO8601Parser.getHoursMinutes(milli));
            }
        }
        return iso8601.toString();
    }

    public static String getHoursMinutes(int milli) {
        int sign = 1;
        if (milli < 0) {
            sign = -1;
            milli *= -1;
        }
        int mins = milli / 60000;
        int hours = mins / 60;
        mins %= 60;
        if (sign == -1) {
            return "-" + ISO8601Parser.leadZeros(hours, 2) + ":" + ISO8601Parser.leadZeros(mins, 2);
        }
        return "+" + ISO8601Parser.leadZeros(hours, 2) + ":" + ISO8601Parser.leadZeros(mins, 2);
    }

    public static String leadZeros(int v, int l) {
        String val = Integer.toString(v);
        while (val.length() < l) {
            val = "0" + val;
        }
        return val;
    }

    public static String removeTrailingZeros(String s) {
        while (s.endsWith("0")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void main(String[] args) throws DatatypeParseException {
        GregorianCalendar cl = ISO8601Parser.parseISO8601Date("1242-04-14");
        System.err.println("1242-04-14");
        System.err.println(cl.get(0));
        System.err.println(cl.get(1));
        System.err.println(cl.get(2));
        System.err.println(cl.get(5));
        cl = ISO8601Parser.parseISO8601Time("23:34:45.001Z");
        System.err.println("23:34:45.001Z");
        System.err.println(cl.get(11));
        System.err.println(cl.get(12));
        System.err.println(cl.get(13));
        System.err.println(cl.get(14));
        System.err.println(cl.get(15));
        cl = ISO8601Parser.parseISO8601DateTime("1242-04-14T23:34:45.2015+13:30");
        System.err.println("1242-04-14T23:34:45.2015+14:30");
        System.err.println(cl.get(0));
        System.err.println(cl.get(1));
        System.err.println(cl.get(2));
        System.err.println(cl.get(5));
        System.err.println(cl.get(11));
        System.err.println(cl.get(12));
        System.err.println(cl.get(13));
        System.err.println(cl.get(14));
        System.err.println(cl.get(15));
        System.err.println(ISO8601Parser.verifyDay(100, 3, 32));
        System.err.println(ISO8601Parser.verifyDay(100, 3, 31));
        System.err.println(ISO8601Parser.verifyDay(100, 4, 31));
        System.err.println(ISO8601Parser.verifyDay(104, 2, 29));
        System.err.println(ISO8601Parser.verifyDay(100, 2, 29));
        System.err.println(ISO8601Parser.verifyDay(100, 3, 29));
        System.err.println(ISO8601Parser.verifyDay(100, 4, 29));
        System.err.println(ISO8601Parser.verifyDay(104, 5, 31));
    }

    public static boolean verifyDay(int year, int month, int day) {
        if (!ISO8601Parser.verifyDay(month, day)) {
            return false;
        }
        return day != 29 || month != 2 || year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static boolean verifyDay(int month, int day) {
        if (!ISO8601Parser.verifyDay(day)) {
            return false;
        }
        return !(day == 31 ? month != 1 && month != 3 && month != 5 && month != 7 && month != 8 && month != 10 && month != 12 : day == 30 && month == 2);
    }

    public static boolean verifyDay(int day) {
        return day <= 31;
    }
}

