/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.mem;

public class MemoryManager {
    public static final int NODES_PER_MB_IN_MEM = 800;

    public static final long estimateHeapSpace() {
        long max = Runtime.getRuntime().maxMemory();
        if (max == Long.MAX_VALUE) {
            max = Runtime.getRuntime().freeMemory();
        }
        return max;
    }

    public static final long estimateFreeSpace() {
        System.gc();
        long max = Runtime.getRuntime().maxMemory();
        long used = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        return free + (max - used);
    }

    public static final int estimateMaxNodes() {
        return (int)(MemoryManager.estimateFreeSpace() / 0x100000L * 800L);
    }

    public static final int estimateMaxStatements(int stmtLength) {
        return (int)(MemoryManager.estimateFreeSpace() / 0x100000L * (long)(800 / stmtLength));
    }
}

