/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.BNodeHandler;
import org.semanticweb.yars.nx.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NqParser
implements Iterator<Node[]> {
    private boolean _strict;
    private BNodeHandler _bnh;
    private Node[] _current;
    private BufferedReader _br;
    private int _lineNo;

    public NqParser(Reader r) throws ParseException, IOException {
        this(r, false);
    }

    public NqParser(Reader r, boolean strict) throws IOException {
        String line;
        this._strict = strict;
        this._lineNo = 0;
        this._bnh = new DummyBNodeHandler();
        this._br = new BufferedReader(r);
        while ((line = this._br.readLine()) != null) {
            ++this._lineNo;
            try {
                Node[] n = this.parseNodes(line);
                if (n == null) continue;
                this._current = new Node[n.length];
                System.arraycopy(n, 0, this._current, 0, n.length);
                break;
            }
            catch (ParseException pe) {
                if (this._strict) {
                    throw new RuntimeException(new ParseException(pe));
                }
                System.err.println("warning on line " + this._lineNo + " " + line + " : " + pe.getMessage());
            }
            catch (RuntimeException ex) {
                if (this._strict) {
                    throw ex;
                }
                System.err.println("warning in NqParser constructor " + this._lineNo + " " + line + " " + ex.getMessage());
            }
        }
    }

    public NqParser(Reader r, boolean unescapeLiterals, boolean strict) throws IOException {
        this(r, strict);
    }

    public void setBNodeHandler(BNodeHandler bnh) {
        this._bnh = bnh;
    }

    public BNodeHandler getBNodeHandler() {
        return this._bnh;
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public Node[] next() {
        Node[] result = new Node[this._current.length];
        System.arraycopy(this._current, 0, result, 0, this._current.length);
        this._current = null;
        try {
            String line;
            while ((line = this._br.readLine()) != null) {
                ++this._lineNo;
                try {
                    Node[] n = this.parseNodes(line);
                    if (n == null) continue;
                    this._current = new Node[n.length];
                    System.arraycopy(n, 0, this._current, 0, n.length);
                    break;
                }
                catch (ParseException pe) {
                    System.err.println("warning in NqParser.next on line " + this._lineNo + " " + line + " : " + pe.getMessage());
                }
                catch (RuntimeException e) {
                    System.err.println("warning on line " + this._lineNo + " " + line + " : " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Node[] parseNodes(String line) throws ParseException {
        ArrayList<Node> n = new ArrayList<Node>();
        int firstIndex = 0;
        int lastIndex = 0;
        int pos = 0;
        String value = line.trim();
        while (!(value = value.substring(firstIndex).trim()).equals(".") && !value.equals("\n")) {
            if (value.startsWith("_")) {
                lastIndex = value.indexOf(" ");
                n.add(this.parseBNode(value, 2, lastIndex));
            } else if (value.startsWith("<")) {
                lastIndex = value.indexOf("> ");
                n.add(new Resource(value.substring(0, lastIndex + 1), true));
            } else if (value.startsWith("\"")) {
                block14: {
                    lastIndex = value.indexOf(34, 2);
                    do {
                        boolean escaped = false;
                        for (int temp = lastIndex - 1; temp > 0 && value.charAt(temp) == '\\'; --temp) {
                            escaped = !escaped;
                        }
                        if (!escaped) break block14;
                        if (++lastIndex != value.length()) continue;
                        throw new ParseException("Cannot find the (unescaped) \" end of literal");
                    } while ((lastIndex = value.indexOf(34, lastIndex)) != -1);
                    throw new ParseException("Cannot find the (unescaped) \" end of literal");
                }
                n.add(NqParser.parseLiteral(value, 1, lastIndex));
                if (value.charAt(lastIndex + 1) == '@') {
                    lastIndex = value.indexOf(32, lastIndex + 1) - 1;
                } else if (value.charAt(lastIndex + 1) == '^') {
                    lastIndex = value.indexOf(62, lastIndex + 1);
                }
            } else if (value.startsWith("?")) {
                lastIndex = value.indexOf(" ");
                n.add(NqParser.parseVariable(value, 1, lastIndex));
            } else {
                throw new ParseException("cannot parse " + pos + "th element: " + value);
            }
            firstIndex = lastIndex + 1;
            ++pos;
        }
        return n.toArray(new Node[n.size()]);
    }

    private static Resource parseResource(String value, int fromIndex, int toIndex) throws ParseException {
        if (toIndex <= -1) {
            throw new ParseException("Error parsing resource subject from triple:\n" + value + "\nExpected ending '> ' not found.\n");
        }
        String data = value.substring(fromIndex, toIndex);
        return new Resource(data);
    }

    private static Variable parseVariable(String value, int fromIndex, int toIndex) throws ParseException {
        if (toIndex <= -1) {
            throw new ParseException("Error parsing variable from segment:\n" + value + "\nExpected ending ' ' not found\n");
        }
        String data = value.substring(fromIndex, toIndex);
        return new Variable(data);
    }

    private BNode parseBNode(String value, int fromIndex, int toIndex) throws ParseException {
        if (toIndex <= -1) {
            throw new ParseException("Error parsing bnode subject from triple:\n" + value + "\nExpected ending ' ' not found.\n");
        }
        String data = value.substring(fromIndex, toIndex);
        return this._bnh.getBNode(data);
    }

    public static Literal parseLiteral(String str) throws ParseException {
        if (str.charAt(0) != '\"') {
            throw new ParseException("literal must be enclosed with \"\"");
        }
        return NqParser.parseLiteral(str, 1, str.length());
    }

    public static Variable parseVariable(String str) throws ParseException {
        if (str.charAt(0) != '?') {
            throw new ParseException("variable must start with ?");
        }
        return NqParser.parseVariable(str, 1, str.length());
    }

    public static Resource parseResource(String str) throws ParseException {
        if (str.charAt(0) != '<' && str.charAt(str.length() - 1) != '>') {
            throw new ParseException("resource must be enclosed with <>");
        }
        return new Resource(str, true);
    }

    public static BNode parseBNode(String str) throws ParseException {
        if (str.charAt(0) != '_' || str.charAt(1) != ':') {
            throw new ParseException("bnode must be enclosed with <>");
        }
        String data = str.substring(2, str.length());
        return new BNode(data);
    }

    public static Node parseNode(String str) throws ParseException {
        if (str.charAt(0) == '_') {
            return NqParser.parseBNode(str);
        }
        if (str.charAt(0) == '<') {
            return NqParser.parseResource(str);
        }
        if (str.charAt(0) == '\"') {
            return NqParser.parseLiteral(str);
        }
        if (str.charAt(0) == '?') {
            return NqParser.parseVariable(str);
        }
        throw new ParseException("cannot parse " + str);
    }

    private static Literal parseLiteral(String value, int fromIndex, int toIndex) throws ParseException {
        String literalProp;
        if (toIndex <= -1) {
            throw new ParseException("Error parsing object literal from triple :\n" + value + "\nCannot find closing object delimiter '\"'.\n");
        }
        int endquoteIndex = value.lastIndexOf(34);
        String literal = value.substring(fromIndex, endquoteIndex);
        ++endquoteIndex;
        try {
            literalProp = value.substring(endquoteIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("Error checking for datatype/lang property of object literal from triple :\n" + value + "\nNo closing '.' in triple?\n");
        }
        literalProp.trim();
        if (literalProp.startsWith("@")) {
            int end = literalProp.indexOf(32);
            if (end < 0) {
                end = literalProp.length();
            }
            String lang = literalProp.substring(1, end).trim();
            return new Literal(literal, lang);
        }
        if (literalProp.startsWith("^^")) {
            toIndex = literalProp.indexOf("> ");
            if (toIndex <= -1) {
                if (literalProp.charAt(literalProp.length() - 1) == '>') {
                    toIndex = literalProp.length() - 1;
                } else {
                    throw new ParseException("Error checking for datatype property of object literal from triple :\n" + value + "\nNo closing > after datatype property\n");
                }
            }
            Resource dt = new Resource(literalProp.substring(3, toIndex));
            return new Literal(literal, dt);
        }
        return new Literal(literal, (String)null);
    }

    private class DummyBNodeHandler
    implements BNodeHandler {
        private DummyBNodeHandler() {
        }

        public BNode getBNode(String id) {
            return new BNode(id);
        }
    }
}

