/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.sort;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSortIterator
implements Iterator<Node[]> {
    static transient Logger _log = Logger.getLogger(MergeSortIterator.class.getName());
    private MergeSortArgs _args;
    private PriorityQueue<NodeArrayStreamPair> _q;
    private Node[] _current = null;
    private long _count = 0L;
    private long _dupes;
    private NodeArrayStreamPair[] _last;

    public MergeSortIterator(Iterator<Node[]> ... segments) {
        this(new MergeSortArgs(segments));
    }

    public MergeSortIterator(MergeSortArgs args) {
        this._args = args;
        this._dupes = this._args._dupes;
        this._q = new PriorityQueue();
        this._last = new NodeArrayStreamPair[this._args._in.length];
        for (int i = 0; i < this._last.length; ++i) {
            this.loadNext(i);
        }
        if (this._q.size() == 0) {
            return;
        }
        this.prepareNext();
    }

    @Override
    public Node[] next() {
        Node[] result = new Node[this._current.length];
        System.arraycopy(this._current, 0, result, 0, this._current.length);
        this.prepareNext();
        return result;
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    private void prepareNext() {
        Node[] next = null;
        while (this._q.size() != 0) {
            NodeArrayStreamPair nsp = this._q.poll();
            next = nsp.getNodes();
            ++this._count;
            if (this._args._ticks > 0 && this._count % (long)this._args._ticks == 0L) {
                _log.info("Merged " + this._count + " with " + this._dupes + " duplicates.");
            }
            this.loadNext(nsp);
            if (this._current == null || this._args._nc.compare(this._current, next) != 0) {
                this._current = next;
                return;
            }
            ++this._dupes;
        }
        this._current = null;
    }

    private void loadNext(NodeArrayStreamPair current) {
        if (this._last[current.getStream()] != null && this._last[current.getStream()] == current) {
            this.loadNext(current.getStream());
        }
    }

    private void loadNext(int stream) {
        NodeArrayStreamPair nsp = null;
        NodeArrayStreamPair last = null;
        Node[] na = null;
        int k = 0;
        for (int u = 0; u < this._args._linesPerBatch && this._args._in[stream].hasNext(); ++u) {
            ++k;
            na = (Node[])this._args._in[stream].next();
            nsp = new NodeArrayStreamPair(na, stream, this._args._nc);
            this._q.add(nsp);
            last = nsp;
        }
        this._last[stream] = last;
    }

    public long duplicates() {
        return this._dupes;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long count() {
        return this._count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergeSortArgs {
        private final Iterator<Node[]>[] _in;
        private Comparator<Node[]> _nc = NodeComparator.NC;
        private int _linesPerBatch = 1;
        private long _dupes;
        private int _ticks = 0;

        public MergeSortArgs(Iterator<Node[]> ... in) {
            this._in = in;
            this._nc = NodeComparator.NC;
            this._linesPerBatch = 1;
            this._dupes = 0L;
        }

        public void setComparator(Comparator<Node[]> nc) {
            this._nc = nc;
        }

        public void setLinesPerBatch(int linesPerBatch) {
            if (linesPerBatch > 0) {
                this._linesPerBatch = linesPerBatch;
            }
        }

        public void setDuplicates(long duplicates) {
            this._dupes = duplicates;
        }

        public void setTicks(int ticks) {
            this._ticks = ticks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeArrayStreamPair
    implements Comparable<NodeArrayStreamPair> {
        private Node[] nodes;
        private int stream;
        private Comparator<Node[]> nc;

        private NodeArrayStreamPair(Node[] _nodes, int _stream, Comparator<Node[]> comp) {
            this.nodes = _nodes;
            this.stream = _stream;
            this.nc = comp;
        }

        public Node[] getNodes() {
            return this.nodes;
        }

        public int getStream() {
            return this.stream;
        }

        public void setNodes(Node[] _nodes) {
            this.nodes = _nodes;
        }

        public void setStream(int _stream) {
            this.stream = _stream;
        }

        @Override
        public int compareTo(NodeArrayStreamPair o) {
            return this.nc.compare(this.nodes, o.getNodes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof NodeArrayStreamPair) {
                NodeArrayStreamPair nsp = (NodeArrayStreamPair)o;
                return this.nc.compare(this.nodes, nsp.nodes) == 0;
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not implemented.");
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("NodeStreamPair : Nodes :");
            for (Node n : this.nodes) {
                buf.append(n.toN3() + " ");
            }
            buf.append("Stream :" + this.stream);
            return buf.toString();
        }
    }
}

